// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent/Query/hkpCdPointCollector.h>
#include <Physics2012/Collide/Query/Collector/PointCollector/hkpRootCdPoint.h>


/// This class collects only the closest contact point returned in addCdPoint() callbacks.
/// Please read the notes for hkpCdPointCollector for information about how these collectors are used.
/// Note: As this class cannot store hkpCdBody information, which may be just temporary, it converts the
/// hkpCdBody into a hkpRootCdPoint.
class HK_EXPORT_PHYSICS_2012 hkpClosestCdPointCollector : public hkpCdPointCollector
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpClosestCdPointCollector);

            /// Constructor calls reset.
        inline hkpClosestCdPointCollector();

            /// Resets the early out condition.
            /// You must call this function if you want to reuse an object of this class.
        inline void reset();

        inline virtual ~hkpClosestCdPointCollector();

            /// Returns true, if this class has collected at least one hit
        inline hkBool hasHit( ) const;

            /// Get the full hit information.
        inline const hkpRootCdPoint& getHit() const;

            /// Returns only the physical hit information: position, normal, distance.
            /// This is identical to getHit().m_contact
        inline const hkContactPoint& getHitContact() const;

        inline const hkVector4& getUnweldedNormal() const { return m_unweldedNormal; }

    protected:

            // this implementation keeps track of the hkpCdPoint with the smallest distance
        virtual void addCdPoint( const hkpCdPoint& pointInfo ) ;

    protected:
        hkpRootCdPoint  m_hitPoint;

        hkVector4 m_unweldedNormal;
};

#include <Physics2012/Collide/Query/Collector/PointCollector/hkpClosestCdPointCollector.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
