// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Query/Collector/PointCollector/hkpAllCdPointCollector.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>

void hkpAllCdPointCollector::addCdPoint( const hkpCdPoint& event )
{
    hkpRootCdPoint& hit = m_hits.expandOne();

    hit.m_contact = event.getContact();
    hit.m_rootCollidableA = event.m_cdBodyA.getRootCollidable();
    hit.m_shapeKeyA = event.m_cdBodyA.getShapeKey();
    // HAVOK 2010.2 CUSTOM CODE - STL 2010/06/30 - Add shape key heirarchies to hkpRootCdPoint.  Code from
    // David Wong of Havok.
    //
    {
        int cdBodyHierarchyDepth = 0;
        const hkpCdBody* currBody = &event.m_cdBodyA;
        while (currBody->getParent())
        {
            cdBodyHierarchyDepth++;
            currBody = currBody->getParent();
        }
        HK_ASSERT(0x0, cdBodyHierarchyDepth < hkpRootCdPoint::MAX_HIERARCHY_DEPTH, "Shape heirarchy too deep.  Memory overwrite will occur.");

        currBody = &event.m_cdBodyA;
        hit.m_shapeKeysA[cdBodyHierarchyDepth] = HK_INVALID_SHAPE_KEY;
        for (int i = cdBodyHierarchyDepth - 1; i >= 0; i--)
        {
            hit.m_shapeKeysA[i] = currBody->m_shapeKey;
            currBody = currBody->getParent();
        }
    }
    //
    // HAVOK 2010.2 CUSTOM CODE - STL 2010/06/30 - Add shape key heirarchies to hkpRootCdPoint.  Code from
    // David Wong of Havok.

    hit.m_rootCollidableB = event.m_cdBodyB.getRootCollidable();
    hit.m_shapeKeyB = event.m_cdBodyB.getShapeKey();
    // HAVOK 2010.2 CUSTOM CODE - STL 2010/06/30 - Add shape key heirarchies to hkpRootCdPoint.  Code from
    // David Wong of Havok.
    //
    {
        int cdBodyHierarchyDepth = 0;
        const hkpCdBody* currBody = &event.m_cdBodyB;
        while (currBody->getParent())
        {
            cdBodyHierarchyDepth++;
            currBody = currBody->getParent();
        }
        HK_ASSERT(0x0, cdBodyHierarchyDepth < hkpRootCdPoint::MAX_HIERARCHY_DEPTH, "Shape heirarchy too deep.  Memory overwrite will occur.");

        currBody = &event.m_cdBodyB;
        hit.m_shapeKeysB[cdBodyHierarchyDepth] = HK_INVALID_SHAPE_KEY;
        for (int i = cdBodyHierarchyDepth - 1; i >= 0; i--)
        {
            hit.m_shapeKeysB[i] = currBody->m_shapeKey;
            currBody = currBody->getParent();
        }
    }
    //
    // HAVOK 2010.2 CUSTOM CODE - STL 2010/06/30 - Add shape key heirarchies to hkpRootCdPoint.  Code from
    // David Wong of Havok.
}

void hkpAllCdPointCollector::sortHits( )
{
    hkSort( m_hits.begin(), m_hits.getSize() );
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
