// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/hkpShape.h>
class hkpCollidable;

    /// As most of data in a hkBody is just temporary,
    /// we can only extract the root information from a hkBody
    ///
    /// If you need more detailed information, you have to implement a collector
    /// yourself.
    ///
    /// Note: If you use hkpWorld/hkpPhantom::getPenetrations(), than object A will always be the query
    /// object and object B will be the hit object
struct HK_EXPORT_PHYSICS_2012 hkpRootCdBodyPair
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkpRootCdBodyPair );

        /// The root collidable of object A
    const hkpCollidable*    m_rootCollidableA;

        /// The shape key of the colliding shape of object A.
        /// Note: if your root collidable is a hkpMeshShape, this will be the subpart and triangle index
    hkpShapeKey         m_shapeKeyA;

        /// The root collidable of object B
    const hkpCollidable*    m_rootCollidableB;

        /// The shape key of the colliding shape of object B
    hkpShapeKey         m_shapeKeyB;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
