// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent/Query/hkpCdBodyPairCollector.h>


/// hkpFlagCdBodyPairCollector collects only a boolean flag, indicating whether there is a hit or not.
/// It is useful if you want to simply know whether two objects (where one or both are shape collections)
/// are overlapping or not.
class HK_EXPORT_PHYSICS_2012 hkpFlagCdBodyPairCollector : public hkpCdBodyPairCollector
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpFlagCdBodyPairCollector);

            /// Constructor calls reset().
        inline hkpFlagCdBodyPairCollector();

        inline virtual ~hkpFlagCdBodyPairCollector();

            /// This function returns true if this class has collected a hit.
        inline hkBool hasHit( ) const;

    protected:
        virtual void addCdBodyPair( const hkpCdBody& bodyA, const hkpCdBody& bodyB );
};

#include <Physics2012/Collide/Query/Collector/BodyPairCollector/hkpFlagCdBodyPairCollector.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
