// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent/Query/hkpCdBodyPairCollector.h>
#include <Physics2012/Collide/Query/Collector/BodyPairCollector/hkpRootCdBodyPair.h>


    /// hkpAllCdBodyPairCollector collects all body pairs from the hkpCollisionAgent::getPenetrations() call.
    /// It simply takes all hkpCdBody pairs and stores them into a list, which you can get from calling getHits().
    /// It never causes an early out.
    /// Note: As this class actually can't store the hkpCdBody, it converts each hkpCdBody into
    /// the root hkpCollidable and the (leave) hkpShapeKey. If you have only one hkpShapeCollection in your shape hierarchy,
    /// this information should be enough to identify your triangle. If you need access to all details, you have to
    /// implement your own hkpCdBodyPairCollector.
class HK_EXPORT_PHYSICS_2012 hkpAllCdBodyPairCollector : public hkpCdBodyPairCollector
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpAllCdBodyPairCollector);

            /// Constructor calls reset()
        inline hkpAllCdBodyPairCollector();

            /// Resets the early out condition and empties the array of hits.
            /// You must call this function if you want to reuse an object of this class.
        inline virtual void reset();

        inline virtual ~hkpAllCdBodyPairCollector();

            /// Get all the hits
        inline const hkArray<hkpRootCdBodyPair>& getHits() const;

    protected:

        virtual void addCdBodyPair( const hkpCdBody& bodyA, const hkpCdBody& bodyB );

    protected:
        hkInplaceArray<hkpRootCdBodyPair, 16> m_hits;
};

#include <Physics2012/Collide/Query/Collector/BodyPairCollector/hkpAllCdBodyPairCollector.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
