// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


    /// This class is used as an input structure for hkpWorld::castRay and hkpAabbPhantom::castRay
struct HK_EXPORT_PHYSICS_2012 hkpWorldRayCastInput
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkpWorldRayCastInput );

    /// The starting point of the ray in world space.
    hkVector4 m_from;

    /// The end point of the ray in world space.
    hkVector4 m_to;

    /// Determines whether m_filterInfo is compared with filter info for hkpShapeCollection child shapes
    /// in addition to it being tested against the hkpCollidable's filter info (the filter set in
    /// hkpRigidBodyCinfo::m_collisionFilterInfo). Default is false.
    hkBool m_enableShapeCollectionFilter;

    /// Ray's filter value. Default is zero.
    hkUint32 m_filterInfo;

    /// User defined data
    hkUlong m_userData;

    hkpWorldRayCastInput()
    :   m_enableShapeCollectionFilter(false),
        m_filterInfo(0),
        m_userData(0)
    {}
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
