// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Object/hkReferencedObject.h>
#include <Physics2012/Collide/hkpExport.h>

class hkpCdBody;
struct hkpCollisionInput;

    /// This filter is used to determine how a convex list shape is treated in a collision.
    /// Please consult the user guide section on convex list shapes for details.
class HK_EXPORT_PHYSICS_2012 hkpConvexListFilter : public hkReferencedObject
{
    public:

        HK_DECLARE_REFLECTION();

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CDINFO );

            /// This specifies how a convex list shape should be treated in a particular collision.
        enum ConvexListCollisionType
        {
                /// Use the normal convex list collision detection, i.e., collide against the convex hull first, then
                /// check the children if necessary.
            TREAT_CONVEX_LIST_AS_NORMAL,

                /// Treat the convex list shape as a list, i.e., always check the children. This is only necessary for
                /// getting the best "welding" between convex list shapes and landscapes.
            TREAT_CONVEX_LIST_AS_LIST,

                /// Treat the convex list shape as a convex object.
            TREAT_CONVEX_LIST_AS_CONVEX
        };

            /// This callback is fired for all collisions with a convex list shape.
        virtual ConvexListCollisionType getConvexListCollisionType( const hkpCdBody& convexListBody, const hkpCdBody& otherBody, const hkpCollisionInput& input ) const = 0;

    protected:

        hkpConvexListFilter() {}
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
