// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Object/hkReferencedObject.h>
#include <Physics2012/Collide/Filter/hkpCollidableCollidableFilter.h>
#include <Physics2012/Collide/Filter/hkpRayCollidableFilter.h>
#include <Physics2012/Collide/Filter/hkpShapeCollectionFilter.h>
#include <Physics2012/Collide/Shape/Query/hkpRayShapeCollectionFilter.h>



class hkpBvTreeShape;
class hkpWorld;


    /// This class inherits from all four collision filters. These are all the filters used by the system.
    /// Typically you inherit from this, to provide an adaptor to a collision filter with some unified behavior.
    /// See hkpGroupFilter for an example of this.
class HK_EXPORT_PHYSICS_2012 hkpCollisionFilter : public hkReferencedObject,
                            public hkpCollidableCollidableFilter,
                            public hkpShapeCollectionFilter,
                            public hkpRayShapeCollectionFilter,
                            public hkpRayCollidableFilter
{

    public:

        HK_DECLARE_REFLECTION();
        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CDINFO );

            // note that only filters of type HK_FILTER_GROUP will be executed on spu currently
        enum hkpFilterType
        {
            HK_FILTER_UNKNOWN       = 0,
            HK_FILTER_NULL          = 1,
            HK_FILTER_GROUP         = 2,
            HK_FILTER_LIST          = 3,
            HK_FILTER_CUSTOM        = 4,
            HK_FILTER_PAIR          = 5,
            HK_FILTER_CONSTRAINT    = 6,
        };

    public:

        hkpCollisionFilter();

            /// Initialize filter upon adding it to world.
            /// hkpConstraintCollisionFilter implementation adds filter as constraintListener
        virtual void init( hkpWorld* world ){}

            /// Checks two collidables
        virtual hkBool isCollisionEnabled( const hkpCollidable& a, const hkpCollidable& b ) const = 0;

            /// hkpShapeCollectionFilter interface forwarding
        virtual hkBool isCollisionEnabled( const hkpCollisionInput& input, const hkpCdBody& a, const hkpCdBody& b,
                                           const HK_SHAPE_CONTAINER& bContainer, hkpShapeKey bKey ) const = 0;

            /// hkpShapeCollectionFilter interface forwarding
        virtual hkBool isCollisionEnabled( const hkpCollisionInput& input, const hkpCdBody& collectionBodyA,
                                           const hkpCdBody& collectionBodyB, const HK_SHAPE_CONTAINER& containerShapeA,
                                           const HK_SHAPE_CONTAINER& containerShapeB,
                                           hkpShapeKey keyA, hkpShapeKey keyB ) const = 0;

            /// Default hkpShapeCollectionFilter interface implementation
        virtual int numShapeKeyHitsLimitBreached( const hkpCollisionInput& input,
                                                  const hkpCdBody& bodyA, const hkpCdBody& bodyB,
                                                  const hkpBvTreeShape* bvTreeShapeB, hkAabb& aabb,
                                                  hkpShapeKey* shapeKeysInOut, int shapeKeysCapacity) const;

            /// hkpRayShapeCollectionFilter interface forwarding
        virtual hkBool isCollisionEnabled( const hkpShapeRayCastInput& aInput, const HK_SHAPE_CONTAINER& bContainer,
                                           hkpShapeKey bKey ) const = 0;

            /// hkpRayCollidableFilter interface forwarding
        virtual hkBool isCollisionEnabled( const hkpWorldRayCastInput& a, const hkpCollidable& collidableB ) const = 0;

    public:

        hkUint32 m_prepad[2];
        hkEnum<hkpFilterType,hkUint32> m_type;
        hkUint32 m_postpad[3];
};

HK_REFLECT_ENUM(HK_EXPORT_PHYSICS_2012, hkpCollisionFilter::hkpFilterType);

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
