// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Filter/Group/hkpGroupFilter.h>

/// A helper class to create a nice predefined set of collision groups (of course you can use your own enums).
class hkpGroupFilterSetup
{
    public:
        /// Basic groups for game objects.
        enum DefaultCollisionGroups
        {
            /// collides always with everything (no layer collision detection used).
            LAYER_NONE = 0,

            /// collides with everything but LAYER_KEYFRAME.
            LAYER_STATIC,

            /// collides with everything.
            LAYER_DYNAMIC,

            /// collides with everything.
            LAYER_PLAYER,

            /// collides with everything.
            LAYER_AI,

            /// collides with everything but LAYER_KEYFRAME, LAYER_STATIC (good for keyframe animation).
            LAYER_KEYFRAME,

            /// collides with everything.
            LAYER_DEBRIS,

            /// collides with everything but LAYER_FAST_DEBRIS.
            LAYER_FAST_DEBRIS
        };

            /// initialize the group filter (see hkpGroupFilter for details).
        HK_ALWAYS_INLINE static void HK_CALL setupGroupFilter( hkpGroupFilter* filter )
        {
            hkUint32 allBits = (1<<LAYER_STATIC) | (1<<LAYER_DYNAMIC) | (1<<LAYER_PLAYER) | (1<<LAYER_AI) | (1<<LAYER_KEYFRAME) |(1<<LAYER_DEBRIS) | (1<<LAYER_FAST_DEBRIS);
            filter->enableCollisionsUsingBitfield ( allBits, allBits );
            filter->enableCollisionsUsingBitfield ( 1<<LAYER_NONE, 0xffffffff );
            filter->enableCollisionsUsingBitfield ( 0xffffffff, 1<<LAYER_NONE );
            filter->disableCollisionsBetween( LAYER_KEYFRAME,     LAYER_KEYFRAME);
            filter->disableCollisionsBetween( LAYER_KEYFRAME,     LAYER_STATIC );
            filter->disableCollisionsBetween( LAYER_FAST_DEBRIS,  LAYER_FAST_DEBRIS );
        }

            /// initialize the specialized 64 layer group filter (see hkpGroupFilter64Layers for details).
        HK_ALWAYS_INLINE static void HK_CALL setupGroupFilter( hkpGroupFilter64Layers* filter )
        {
            hkUint64 allBits = (hkUint64(1)<<LAYER_STATIC) | (hkUint64(1)<<LAYER_DYNAMIC) | (hkUint64(1)<<LAYER_PLAYER) | (hkUint64(1)<<LAYER_AI) | (hkUint64(1)<<LAYER_KEYFRAME) |(hkUint64(1)<<LAYER_DEBRIS) | (hkUint64(1)<<LAYER_FAST_DEBRIS);
            filter->enableCollisionsUsingBitfield ( allBits, allBits );
            filter->enableCollisionsUsingBitfield ( hkUint64(1)<<LAYER_NONE, 0xffffffffffffffff );
            filter->enableCollisionsUsingBitfield ( 0xffffffffffffffff, hkUint64(1)<<LAYER_NONE );
            filter->disableCollisionsBetween( LAYER_KEYFRAME,     LAYER_KEYFRAME);
            filter->disableCollisionsBetween( LAYER_KEYFRAME,     LAYER_STATIC );
            filter->disableCollisionsBetween( LAYER_FAST_DEBRIS,  LAYER_FAST_DEBRIS );
        }
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
