// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Filter/hkpConvexListFilter.h>

    /// This is the default filter that is used for a convex list shape. You should change this if you wish to
    /// improve performance of convex list shapes by treating them as convex for some types of collisions.
    /// For example you could treat a convex list shape as a convex object for collisions with a smooth landscape, or
    /// for collisions with fast moving debris.
class HK_EXPORT_PHYSICS_2012 hkpDefaultConvexListFilter : public hkpConvexListFilter
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

        hkpDefaultConvexListFilter() {}

            // If the convex list shape is colliding with a landscape, we dispatch the convex list shape as a list, to ensure
            // correct welding happens. Otherwise we dispatch convex list shape as normal.
        ConvexListCollisionType getConvexListCollisionType( const hkpCdBody& convexListBody, const hkpCdBody& otherBody, const hkpCollisionInput& input ) const;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
