// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent/ContactMgr/hkpContactMgr.h>

class hkpCollidable;
struct hkpCollisionInput;
struct hkpProcessCdPoint;


    /// An hkpContactMgr that doesn't add any contact points.
class HK_EXPORT_PHYSICS_2012 hkpNullContactMgr: public hkpContactMgr
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        hkpNullContactMgr() : hkpContactMgr( hkpContactMgr::TYPE_NULL_CONTACT_MGR ){}

            /// No contact points are added in this implementation, however HK_NULL is a valid contact point id (!= HK_INVALID_CONTACT_POINT )
        hkContactPointId addContactPointImpl( const hkpCdBody& a, const hkpCdBody& b, const hkpProcessCollisionInput& env, hkpProcessCollisionOutput& output, const hkpGskCache* contactCache, hkContactPoint& cp)
        { return 0; }

        void removeContactPointImpl( hkContactPointId cpId, hkCollisionConstraintOwner& constraintOwner )
        {}

        void processContactImpl( const hkpCollidable& a, const hkpCollidable& b, const hkpProcessCollisionInput& input, hkpProcessCollisionData& collisionData )
        {}

        ToiAccept addToiImpl( const hkpCdBody& a, const hkpCdBody& b, const hkpProcessCollisionInput& input, hkpProcessCollisionOutput& output, hkTime toi, hkContactPoint& cp, const hkpGskCache* gskCache, hkReal& projectedVelocity, hkpContactPointProperties& properties )
        {
            return TOI_ACCEPT;  // needed for unit tests
        }

        void removeToiImpl( class hkCollisionConstraintOwner& constraintOwner, hkpContactPointProperties& properties )
        {}


        hkResult reserveContactPointsImpl( int numPoints )
        {
            return HK_SUCCESS;
        }

        void cleanup()
        {}

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
