// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/BroadPhase/hkpBroadPhaseHandle.h>
#include <Physics2012/Collide/Agent/Collidable/hkpCollidableQualityType.h>

/// An hkpBroadPhaseHandle with a type. hkpCollidable has a member of type hkpTypedBroadPhaseHandle.
/// If you use the Havok dynamics lib then
/// type can be hkpWorldObject::BROAD_PHASE_ENTITY for entities or hkpWorldObject::BROAD_PHASE_PHANTOM for phantoms.
/// Also you can use
///   - hkpRigidBody* hkpGetRigidBody( hkpCollidable* collidable )
///   - hkpPhantom* hkpGetPhantom(hkpCollidable* collidable)
class HK_EXPORT_PHYSICS_2012 hkpTypedBroadPhaseHandle : public hkpBroadPhaseHandle
{
    public:
#if !defined(HK_PLATFORM_SPU)
        HK_DECLARE_CLASS(hkpTypedBroadPhaseHandle, New, Reflect, BypassCtor);

            ///Creates a new hkpTypedBroadPhaseHandle of the specified type.
            ///Make sure to call setowner before using this handle.
        HK_INLINE hkpTypedBroadPhaseHandle( int type );

            ///Creates a new hkpTypedBroadPhaseHandle of the specified type
        HK_INLINE hkpTypedBroadPhaseHandle( void* owner, int type );

            ///Gets the type. The possible types are defined in hkpWorldObject::BroadPhaseType.
        HK_INLINE int getType() const;

            ///Gets the owner of this handle
        HK_INLINE void setOwner(void* o);

            ///Gets the owner of this handle
        HK_INLINE void* getOwner() const;

            ///Gets the collision filter info. This is an identifying value used by collision filters
            /// - for example, if a group filter is used, this value would encode a collision group and a system group
        HK_INLINE hkUint32 getCollisionFilterInfo() const;

            ///Sets the collision filter info. This is an identifying value used by collision filters
            /// - for example, if a group filter is used, this value would encode a collision group and a system group
        HK_INLINE void setCollisionFilterInfo( hkUint32 info );

#else
            ///Gets the type. The possible types are defined in hkpWorldObject::BroadPhaseType.
        HK_INLINE int getType() const { return m_type; }
#endif

    protected:

        enum { OFFSET_INVALID = 127 };
        inline void setType( int type );
        friend class hkpBroadPhaseBorder; // it overrides the type of its owned phantoms

        hkInt8 m_type;
         // would have padding of 8 here anyway, so keep at 8 and assert if owner more than +/-128 bytes away
        hkInt8 m_ownerOffset; // +nosave

    public:

            /// The quality of the object.
            /// You should use the hkpCollisionDispatcher to get the hkpCollisionQualityInfo
        hkInt8 m_objectQualityType;
        hkUint32 m_collisionFilterInfo;

};

#if !defined(HK_PLATFORM_SPU)
#   include <Physics2012/Collide/Dispatch/BroadPhase/hkpTypedBroadPhaseHandle.inl>
#endif

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
