// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline hkpBroadPhaseListener* hkpTypedBroadPhaseDispatcher::getBroadPhaseListener( int a, int b )
{
    HK_ASSERT(0x4d465ed6, a < HK_MAX_BROADPHASE_TYPE && b < HK_MAX_BROADPHASE_TYPE, "A broadphase listener which has not been set is being called");
    return m_broadPhaseListeners[a][b];
}

inline void hkpTypedBroadPhaseDispatcher::setBroadPhaseListener( hkpBroadPhaseListener* listener, int a, int b )
{
    HK_ASSERT(0x7e237c69, a < HK_MAX_BROADPHASE_TYPE && b < HK_MAX_BROADPHASE_TYPE, "A broadphase listener which has not been set is being called");
    m_broadPhaseListeners[a][b] = listener;
}

inline hkpBroadPhaseListener* hkpTypedBroadPhaseDispatcher::getNullBroadPhaseListener()
{
    return &m_nullBroadPhaseListener;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
