// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Filter/hkpCollidableCollidableFilter.h>
#include <Physics2012/Collide/Dispatch/BroadPhase/hkpNullBroadPhaseListener.h>

class hkpTypedBroadPhaseHandlePair;
class hkpBroadPhaseHandlePair;
class hkpBroadPhaseListener;

#define HK_MAX_BROADPHASE_TYPE 8

class HK_EXPORT_PHYSICS_2012 hkpTypedBroadPhaseDispatcher
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_CDINFO, hkpTypedBroadPhaseDispatcher);

        hkpTypedBroadPhaseDispatcher();

        ~hkpTypedBroadPhaseDispatcher();

        /// sorts and removes duplicates
        static void HK_CALL removeDuplicates( hkArray<hkpBroadPhaseHandlePair>& newPairs, hkArray<hkpBroadPhaseHandlePair>& delPairs );

        ///// swap each pair's internal data so A > B, then sort
        //static void HK_CALL sortPairs( hkpTypedBroadPhaseHandlePair* pairs, int numPairs );

            /// update the dispatcher by merging
        void addPairs( hkpTypedBroadPhaseHandlePair* newPairs, int numNewPairs, const hkpCollidableCollidableFilter* filter ) const;

        void removePairs( hkpTypedBroadPhaseHandlePair* deletedPairs, int numDeletedPairs ) const;


        inline hkpBroadPhaseListener* getBroadPhaseListener( int typeA, int typeB );

        inline void setBroadPhaseListener( hkpBroadPhaseListener* listener, int typeA, int typeB );

        inline hkpBroadPhaseListener* getNullBroadPhaseListener();

    protected:
        hkpBroadPhaseListener*    m_broadPhaseListeners[HK_MAX_BROADPHASE_TYPE][HK_MAX_BROADPHASE_TYPE];
        hkpNullBroadPhaseListener m_nullBroadPhaseListener;
};

#include <Physics2012/Collide/Dispatch/BroadPhase/hkpTypedBroadPhaseDispatcher.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
