// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent3/hkpAgent3.h>

class hkpCollisionDispatcher;
class hkpCollisionAgent;

namespace hkAgent3Bridge
{
        /// This agent3 links in the existing agents
    hkpAgentData* create  ( const hkpAgent3Input& input, hkpAgentEntry* entry, hkpAgentData* agentData );

    hkpAgentData* process ( const hkpAgent3ProcessInput& input, hkpAgentEntry* entry, hkpAgentData* agentData, hkVector4* separatingNormalOut, hkpProcessCollisionOutput& result);

    //void            sepNormalFunc( const hkpAgent3Input& input, hkpAgentData* agentData, hkVector4& separatingNormalOut );

    //hkpAgentData* cleanupFunc ( hkpAgentEntry* entry, hkpAgentData* agentData, hkpContactMgr* mgr );

    void HK_CALL    destroy ( hkpAgentEntry* entry, hkpAgentData* agentData, hkpContactMgr* mgr, hkCollisionConstraintOwner& constraintOwner, hkpCollisionDispatcher* dispatcher );

    void HK_CALL    updateFilter(hkpAgentEntry* entry, hkpAgentData* agentData, const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpContactMgr* mgr, hkCollisionConstraintOwner& constraintOwner);

    void HK_CALL    invalidateTim(hkpAgentEntry* entry, hkpAgentData* agentData, const hkpCollisionInput& input);

    void HK_CALL    warpTime(hkpAgentEntry* entry, hkpAgentData* agentData, hkTime oldtime, hkTime newTime, const hkpCollisionInput& input);

    int  HK_CALL    registerAgent3( hkpCollisionDispatcher* dispatcher );


    void HK_CALL removePoint( hkpAgentEntry* entry, hkpAgentData* agentData, hkContactPointId idToRemove );

    void HK_CALL commitPotential( hkpAgentEntry* entry, hkpAgentData* agentData, hkContactPointId newId );

    void HK_CALL createZombie( hkpAgentEntry* entry, hkpAgentData* agentData, hkContactPointId idTobecomeZombie );

    //
    // Helper functions
    //

    HK_INLINE hkpCollisionAgent*& HK_CALL getChildAgent(hkpAgentData* agentData)
    {
        return *reinterpret_cast<hkpCollisionAgent**>(agentData);
    }

    HK_INLINE hkpAgentData* HK_CALL getAgentDataEnd(hkpAgentData* agentData)
    {
        HK_ASSERT_NO_MSG(0x44ff9925,  HK_NEXT_MULTIPLE_OF( HK_REAL_ALIGNMENT, sizeof(getChildAgent(agentData)) ) <= hkAgent3::MAX_NET_SIZE);
        return hkAddByteOffset( agentData, HK_NEXT_MULTIPLE_OF( HK_REAL_ALIGNMENT, sizeof(getChildAgent(agentData)) ) );
    }



}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
