// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


/// An identifier that is used to link the broadphase with the user application.
/// Each object that is to be added to the broadphase must have a hkpBroadPhaseHandle.
/// For example, the hkpCollidable class has a member of type hkpTypedBroadPhaseHandle
/// (which directly derives from hkpBroadPhaseHandle),
/// allowing Havok rigid bodies to be used with the broadphase. Alternatively, if you are
/// using the broadphase on its own, you can create your own hkpBroadPhaseHandle subclasses.
class HK_EXPORT_PHYSICS_2012 hkpBroadPhaseHandle
{
    public:

        HK_DECLARE_REFLECTION();

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_CDINFO, hkpBroadPhaseHandle);

        hkUint32 m_id; // +nosave

        hkpBroadPhaseHandle(): m_id(0){}
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
