// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpBroadPhaseHandle;

/// This class is a callback, which is called by the hkpBroadPhase::castRay() and hkpBroadPhase::castAabb().
/// Typical implementations are hkpWorldLinearCaster or hkpWorldRayCaster.
class HK_EXPORT_PHYSICS_2012 hkpBroadPhaseCastCollector
{
    //+hk.MemoryTracker(ignore=True)
    public:

        virtual ~hkpBroadPhaseCastCollector() { }

            /// Return fraction (meaning the primitive hist the collidable)
            /// also update the fraction between 0 and 1 where it hits.
            /// The castIndex is the index of the object. Typically if you have done a single
            /// raycast, castIndex is 0, if you do a multiple raycast, castIndex is the ray index
        virtual hkReal addBroadPhaseHandle( const hkpBroadPhaseHandle* broadphaseHandle, int castIndex ) = 0;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
