// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline hkMultiThreadCheck& hkpBroadPhase::getMultiThreadCheck()
{
    return m_multiThreadCheck;
}

inline const hkMultiThreadCheck& hkpBroadPhase::getMultiThreadCheck() const
{
    // Have to cast away const to add the property if necessary
    hkpBroadPhase* nonConstThis = const_cast<hkpBroadPhase*>(this);
    return nonConstThis->getMultiThreadCheck();
}

inline void hkpBroadPhase::markForRead( ) const
{
    m_multiThreadCheck.markForRead();
}

inline void hkpBroadPhase::markForWrite( )
{
    m_multiThreadCheck.markForWrite();
}

inline void hkpBroadPhase::unmarkForRead( ) const
{
    m_multiThreadCheck.unmarkForRead();
}

inline void hkpBroadPhase::unmarkForWrite()
{
    m_multiThreadCheck.unmarkForWrite();
}

inline void hkpBroadPhase::lock()
{
    if ( m_criticalSection )
    {
        lockImplementation();
    }
    else
    {
        markForWrite();
    }
}

inline void hkpBroadPhase::unlock()
{
    if ( m_criticalSection )
    {
        unlockImplementation();
    }
    else
    {
        unmarkForWrite();
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
