// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


HK_INLINE int hkpBoxBoxManifold::getNumPoints() const
{
    return m_numPoints;
}

HK_INLINE hkpFeatureContactPoint& hkpBoxBoxManifold::operator[]( int index )
{
    return m_contactPoints[index];
}

HK_INLINE bool hkpBoxBoxManifold::findInManifold( const hkpFeatureContactPoint& fcp ) const
{
    for (int i = m_numPoints-1; i>=0; i--)
    {
        if ( m_contactPoints[i].m_featureIdA == fcp.m_featureIdA && m_contactPoints[i].m_featureIdB == fcp.m_featureIdB )
        {
            return true;
        }
    }
    return false;
}

HK_INLINE bool hkpBoxBoxManifold::isComplete() const
{
    return m_isComplete;
}

HK_INLINE void hkpBoxBoxManifold::setComplete( bool complete )
{
    m_isComplete = complete;
}

HK_INLINE bool hkpBoxBoxManifold::hasNoPointsLeft() const
{
    return (m_numPoints >= HK_BOXBOX_MANIFOLD_MAX_POINTS);
}

HK_INLINE hkBool32 hkpBoxBoxManifold::isNormalInitialized() const
{
    return m_manifoldNormalA.getW().isLessZero();
}

HK_INLINE void hkpBoxBoxManifold::setNormalInitialized()
{
    m_manifoldNormalA.setW(hkSimdReal_Minus1);
}

HK_INLINE void hkpBoxBoxManifold::clearNormalInitialized()
{
    m_manifoldNormalA.zeroComponent<3>();
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
