// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/BoxBox/hkpBoxBoxContactPoint.h>

class hkpCdBody;
struct hkpProcessCollisionOutput;
struct hkpCollisionInput;


#define HK_BOXBOX_MANIFOLD_MAX_POINTS 8

class HK_EXPORT_PHYSICS_2012 hkpBoxBoxManifold
{

    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_CDINFO, hkpBoxBoxManifold );

        hkpBoxBoxManifold();

        // for 2.0 bridge
        int addPoint( const hkpCdBody& bodyA, const hkpCdBody& bodyB, hkpFeatureContactPoint& fcp );

        void removePoint( int index );

        HK_INLINE int getNumPoints() const;

        HK_INLINE hkpFeatureContactPoint& operator[]( int index );

        HK_INLINE bool findInManifold( const hkpFeatureContactPoint& fcp ) const;

        HK_INLINE bool isComplete() const;
        HK_INLINE void setComplete( bool complete );

        HK_INLINE bool hasNoPointsLeft() const;
        HK_INLINE hkBool32 isNormalInitialized() const;
        HK_INLINE void setNormalInitialized();
        HK_INLINE void clearNormalInitialized();

    public:
        hkpFeatureContactPoint m_contactPoints[HK_BOXBOX_MANIFOLD_MAX_POINTS];

        hkUchar  m_faceVertexFeatureCount;
        hkUchar  m_numPoints;

        bool m_isComplete;  // a complete manifold is one where no new points can be added via small rotations.

        hkUint32 m_manifoldNormalB;

        hkVector4 m_manifoldNormalA; // .w is initialized flag
};


#include <Physics2012/Collide/BoxBox/hkpBoxBoxManifold.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
