// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent/Collidable/hkpCollidable.h>

struct hkpAgentNnEntry;

/// A hkpLinkedCollidable is a hkpCollidable which is referenced by collision agents. If the agent moves
/// it can update all links pointing to it
#if !defined(HK_PLATFORM_SPU)
class HK_EXPORT_PHYSICS_2012 hkpLinkedCollidable : public hkpCollidable
#else
class HK_EXPORT_PHYSICS_2012 hkpLinkedCollidable: public hkCollidablePpu
#endif
{

#if !defined(HK_PLATFORM_SPU)

    public:

        HK_DECLARE_CLASS(hkpLinkedCollidable, New, Reflect, BypassCtor);

            /// Creates a new hkpLinkedCollidable.
            /// Note: this constructor sets the owner to be HK_NULL, call setOwner to specify the owner and type
        inline hkpLinkedCollidable( const hkpShape* shape, const hkMotionState* ms, int type = 0);

        inline ~hkpLinkedCollidable();

#endif

    public:

        /// A list of links to all persistent agents referencing this object
        struct CollisionEntry
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CDINFO, hkpLinkedCollidable::CollisionEntry );
            HK_DECLARE_POD_TYPE();

            hkpAgentNnEntry* m_agentEntry;
            hkpLinkedCollidable*    m_partner;
        };

#if ! defined (HK_PLATFORM_SPU)
            /// Returns a deterministically ordered copy of the collision entries
        void getCollisionEntriesSorted(hkArray<struct CollisionEntry>& entries) const ;

            /// returns the array of collision entries where we know that they are deterministically ordered (e.g., we know its a non fixed object)
        const hkArray<struct CollisionEntry>& getCollisionEntriesDeterministicUnchecked() const;

        hkArray<struct CollisionEntry>& getCollisionEntriesDeterministicUnchecked();

        hkArray<struct CollisionEntry>& getCollisionEntriesNonDeterministic(){ return m_collisionEntries; }

        const hkArray<struct CollisionEntry>& getCollisionEntriesNonDeterministic()  const { return m_collisionEntries; }

            /// ###ACCESS_CHECKS###( [hkpGetRigidBody(this)->getWorld(),HK_ACCESS_RW] );
        void sortEntries();
#endif


    protected:
        hkArray<struct CollisionEntry> m_collisionEntries; //+nosave

};

#if !defined(HK_PLATFORM_SPU)
#   include <Physics2012/Collide/Agent3/Machine/Nn/hkpLinkedCollidable.inl>
#endif

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
