// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent3/Machine/Midphase/hkpBlockList.h>
#include <Physics2012/Collide/Shape/hkpShape.h>

#define HK_SIZE_OF_SHAPE_KEY_BLOCKS 512

class hkpShapeKeyTrack : public hkpBlockList<hkpShapeKey, HK_SIZE_OF_SHAPE_KEY_BLOCKS>
{
    public:
        hkpShapeKeyTrack();
};

class hkpShapeKeyTrackWriter : public hkpShapeKeyTrack::BatchWriter
{
    public:
#if defined(HK_PLATFORM_SPU)
        HK_INLINE hkpShapeKeyTrackWriter( int dmaGroup ) : hkpShapeKeyTrack::BatchWriter( dmaGroup ) {}
#endif

        void writeBatch( const hkpShapeKey* data, int numElements );
};

class hkpShapeKeyTrackConsumer : public hkpShapeKeyTrack::BatchConsumer
{
    public:
#if defined(HK_PLATFORM_SPU)
        HK_INLINE hkpShapeKeyTrackConsumer( int dmaGroup ) : hkpShapeKeyTrack::BatchConsumer( dmaGroup ) {}
#endif

        hkpShapeKey* getShapeKeysInBuffer( int numShapeKeys );

        void freeShapeKeyBuffer( int numShapeKeys, hkpShapeKey* buffer );
};

#include <Physics2012/Collide/Agent3/Machine/Midphase/hkpShapeKeyTrack.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
