// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/hkpCollide.h>

#include <Physics2012/Collide/Agent3/Machine/Midphase/hkpShapeKeyTrack.h>

hkpShapeKey* hkpShapeKeyTrackConsumer::getShapeKeysInBuffer( int numShapeKeys )
{
    HK_TIMER_BEGIN("ReadShapeKeys",HK_NULL);
    setNumElements( numShapeKeys );

    hkpShapeKey* shapeKeys = hkAllocateStack<hkpShapeKey>( numShapeKeys + 2, "Shapekeys" );
    {
        int count = 0;
        int batchSize;
        hkpShapeKey* key;
        while ( ( batchSize = accessBatch( key ) ) > 0 )
        {
            HK_ASSERT( 0x23a7e88b, count + batchSize <= numShapeKeys, "Shape key track consumer provided too many shape keys." );
            hkString::memCpy4( shapeKeys + count, key, batchSize );
            count += batchSize;
        }
        shapeKeys[numShapeKeys] = HK_INVALID_SHAPE_KEY;
        shapeKeys[numShapeKeys + 1] = HK_INVALID_SHAPE_KEY;
    }
    HK_TIMER_END();
    return shapeKeys;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
