// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

hkpCpuSingleContainerIterator::hkpCpuSingleContainerIterator( const HK_SHAPE_CONTAINER* container, const hkpShapeKey* shapeKeys )
: m_container( container ), m_shapeKeys( shapeKeys ), m_lastShapeKey( HK_INVALID_SHAPE_KEY )
{
}

void hkpCpuSingleContainerIterator::update()
{
    m_lastShapeKey = *m_shapeKeys;
}

hkpShapeKey hkpCpuSingleContainerIterator::getShapeKey()
{
    return m_lastShapeKey;
}

void hkpCpuSingleContainerIterator::setShape( hkpCdBody& body )
{
    HK_ASSERT( 0x342e45a4, m_lastShapeKey != HK_INVALID_SHAPE_KEY, "Shape requested without calling update or when iteration has finished" );
    const hkpShape* extractedShape = m_container->getChildShape( m_lastShapeKey, m_shapeBuffer );
    body.setShape( extractedShape, m_lastShapeKey );
}

hkBool hkpCpuSingleContainerIterator::isCollisionEnabled( const hkpProcessCollisionInput* input, const hkpCdBody* a, const hkpCdBody* b )
{
    HK_ASSERT( 0x342e45a4, m_lastShapeKey != HK_INVALID_SHAPE_KEY, "Collision filter called without calling update or when iteration has finished" );
    return input->m_filter->isCollisionEnabled( *input, *a, *b, *m_container, m_lastShapeKey );
}

void hkpCpuSingleContainerIterator::advance()
{
    ++m_shapeKeys;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
