// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/hkpShape.h>

class HK_EXPORT_PHYSICS_2012 hkpCpuSingleContainerIterator
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkpCpuSingleContainerIterator );

        HK_INLINE hkpCpuSingleContainerIterator( const HK_SHAPE_CONTAINER* container, const hkpShapeKey* shapeKeys );

            /// prepare iterator for being queried for getShapes and getShapeKeys
        HK_INLINE void update();

            /// Return the current shape key.
        HK_INLINE hkpShapeKey getShapeKey();

        HK_INLINE hkBool isCollisionEnabled( const hkpProcessCollisionInput* input, const hkpCdBody* a, const hkpCdBody* b );

            /// Set the body to have the current shape and shape key.
        HK_INLINE void setShape( hkpCdBody& body );

            /// Next time the update is called it should advance.
        HK_INLINE void advance();

    public:
        hkpShapeBuffer m_shapeBuffer;

        const HK_SHAPE_CONTAINER* m_container;

        const hkpShapeKey* m_shapeKeys;

        hkpShapeKey m_lastShapeKey;
};

#include<Physics2012/Collide/Agent3/Machine/1n/hkpCpuSingleContainerIterator.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
