// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

hkpCpuDoubleContainerIterator::hkpCpuDoubleContainerIterator( const HK_SHAPE_CONTAINER* containerA, const HK_SHAPE_CONTAINER* containerB, const hkpShapeKeyPair* shapeKeys )
: m_containerA( containerA ), m_containerB( containerB ), m_shapeKeys( shapeKeys ), m_extractedShapeKeyA( HK_INVALID_SHAPE_KEY ), m_extractedShapeKeyB( HK_INVALID_SHAPE_KEY )
{
    m_lastShapeKeyPair.m_shapeKeyA = HK_INVALID_SHAPE_KEY;
    m_lastShapeKeyPair.m_shapeKeyB = HK_INVALID_SHAPE_KEY;
}

void hkpCpuDoubleContainerIterator::update()
{
    m_lastShapeKeyPair = *m_shapeKeys;
}

hkpShapeKeyPair hkpCpuDoubleContainerIterator::getShapeKeyPair()
{
    return m_lastShapeKeyPair;
}

void hkpCpuDoubleContainerIterator::setShapes( hkpCdBody& bodyA, hkpCdBody& bodyB )
{
    HK_ASSERT( 0x342e45a4, m_lastShapeKeyPair.m_shapeKeyA != HK_INVALID_SHAPE_KEY, "Shape requested without calling update or when iteration has finished" );
    if ( m_extractedShapeKeyA != m_lastShapeKeyPair.m_shapeKeyA )
    {
        m_extractedShapeA = m_containerA->getChildShape( m_lastShapeKeyPair.m_shapeKeyA, m_shapeBufferA );
        m_extractedShapeKeyA = m_lastShapeKeyPair.m_shapeKeyA;
        bodyA.setShape( m_extractedShapeA, m_lastShapeKeyPair.m_shapeKeyA );
    }
    if ( m_extractedShapeKeyB != m_lastShapeKeyPair.m_shapeKeyB )
    {
        m_extractedShapeB = m_containerB->getChildShape( m_lastShapeKeyPair.m_shapeKeyB, m_shapeBufferB );
        m_extractedShapeKeyB = m_lastShapeKeyPair.m_shapeKeyB;
        bodyB.setShape( m_extractedShapeB, m_lastShapeKeyPair.m_shapeKeyB );
    }
}


hkBool hkpCpuDoubleContainerIterator::isCollisionEnabled( const hkpProcessCollisionInput* input, const hkpCdBody* collectionBodyA, const hkpCdBody* collectionBodyB )
{
    HK_ASSERT( 0x342e45a4, m_lastShapeKeyPair.m_shapeKeyA != HK_INVALID_SHAPE_KEY, "Collision filter called without calling update or when iteration has finished" );
    return input->m_filter->isCollisionEnabled( *input, *collectionBodyA, *collectionBodyB, *m_containerA, *m_containerB, m_lastShapeKeyPair.m_shapeKeyA, m_lastShapeKeyPair.m_shapeKeyB );
}

void hkpCpuDoubleContainerIterator::advance()
{
    ++m_shapeKeys;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
