// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/hkpShape.h>
#include <Physics2012/Collide/Shape/hkpShapeContainer.h>
#include <Physics2012/Collide/Filter/hkpCollisionFilter.h>

class HK_EXPORT_PHYSICS_2012 hkpCpuDoubleContainerIterator
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkpCpuDoubleContainerIterator );

        HK_INLINE hkpCpuDoubleContainerIterator( const HK_SHAPE_CONTAINER* containerA, const HK_SHAPE_CONTAINER* containerB, const hkpShapeKeyPair* shapeKeys );

            /// prepare iterator for being queried for getShapes and getShapeKeys
        HK_INLINE void update();

            /// Return the current shape key.
        HK_INLINE hkpShapeKeyPair getShapeKeyPair();

            /// Get the collision filter infos for the two child shapes.
        HK_INLINE hkBool isCollisionEnabled( const hkpProcessCollisionInput* input, const hkpCdBody* collectionBodyA, const hkpCdBody* collectionBodyB );

            /// Set the body to have the current shape and shape key.
        HK_INLINE void setShapes( hkpCdBody& bodyA, hkpCdBody& bodyB );

            /// Next time the update is called it should advance.
        HK_INLINE void advance();

    public:
        hkpShapeBuffer m_shapeBufferA;

        hkpShapeBuffer m_shapeBufferB;

        const HK_SHAPE_CONTAINER* m_containerA;

        const HK_SHAPE_CONTAINER* m_containerB;

        const hkpShapeKeyPair* m_shapeKeys;

        hkpShapeKeyPair m_lastShapeKeyPair;

        hkpShapeKey m_extractedShapeKeyA;

        hkpShapeKey m_extractedShapeKeyB;

        const hkpShape* m_extractedShapeA;

        const hkpShape* m_extractedShapeB;
};

#include<Physics2012/Collide/Agent3/Machine/1n/hkpCpuDoubleContainerIterator.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
