// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

typedef void hkpAgentData;

struct HK_EXPORT_PHYSICS_2012 hkpAgent1nSector
{
    HK_DECLARE_CLASS(hkpAgent1nSector, New);

    enum { SECTOR_SIZE = 512, NET_SECTOR_SIZE = SECTOR_SIZE - HK_REAL_ALIGNMENT };

    hkUint32 m_bytesAllocated;

    hkUint32 m_pad0;
    hkUint32 m_pad1;
    hkUint32 m_pad2;
#if (HK_REAL_ALIGNMENT == 32)
    hkUint32 m_padTo32[4];
    hkUint8 m_data[512-32]; /*[ NET_SECTOR_SIZE ]*/ // Serialization script cannot take enum as array size.
#else
    hkUint8 m_data[512-16]; /*[ NET_SECTOR_SIZE ]*/ // Serialization script cannot take enum as array size.
#endif

    HK_INLINE hkpAgentData* getBegin()
    {
        return reinterpret_cast<hkpAgentData*>( &m_data[0] );
    }

    hkpAgentData* getEnd()
    {
        HK_ASSERT_NO_MSG( 0xf032ef45, unsigned(m_bytesAllocated) <= NET_SECTOR_SIZE );
        return reinterpret_cast<hkpAgentData*>( &m_data[m_bytesAllocated] );
    }

    hkpAgentData* getEndOfCapacity()
    {
        return reinterpret_cast<hkpAgentData*>( &m_data[NET_SECTOR_SIZE] );
    }

    int getCapacity()
    {
        return NET_SECTOR_SIZE;
    }

    int getFreeBytes()
    {
        return static_cast<int>(NET_SECTOR_SIZE - m_bytesAllocated);
    }

    inline hkpAgent1nSector(): m_bytesAllocated(0){}
};

struct HK_EXPORT_PHYSICS_2012 hkpAgent1nTrack
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CDINFO, hkpAgent1nTrack );

    hkArray<hkpAgent1nSector*> m_sectors;

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
