// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent3/hkpAgent3.h>
#include <Physics2012/Collide/Dispatch/hkpCollisionDispatcher.h>

class hkpCollisionDispatcher;
class hkCollisionConstraintOwner;
struct hkConvexListAgent3Data;
struct hkPredGskAgent3Data;
struct hkpAgent1nTrack;

    /// a streamed agent implementing list collisions.
    /// This agent is continuous
namespace hkConvexListAgent3
{
    hkpAgentData*   HK_CALL create          ( const hkpAgent3Input& input, hkpAgentEntry* entry, hkpAgentData* freeMemory );

    hkpAgentData*   HK_CALL process         ( const hkpAgent3ProcessInput& input, hkpAgentEntry* entry, hkpAgentData* agentData, hkVector4* separatingNormal, hkpProcessCollisionOutput& result);

    void            HK_CALL sepNormal       ( const hkpAgent3Input& input, hkpAgentEntry* entry, hkpAgentData* agentData, hkVector4& separatingNormalOut );

    hkpAgentData*   HK_CALL cleanup         ( hkpAgentEntry* entry, hkpAgentData* agentData, hkpContactMgr* mgr, hkCollisionConstraintOwner& constraintOwner );

    void            HK_CALL removePoint     ( hkpAgentEntry* entry, hkpAgentData* agentData, hkContactPointId idToRemove );

    void            HK_CALL commitPotential ( hkpAgentEntry* entry, hkpAgentData* agentData, hkContactPointId idToRemove );

    void            HK_CALL createZombie    ( hkpAgentEntry* entry, hkpAgentData* agentData, hkContactPointId idToConvert );

    void            HK_CALL destroy         ( hkpAgentEntry* entry, hkpAgentData* agentData, hkpContactMgr* mgr, hkCollisionConstraintOwner& constraintOwner, hkpCollisionDispatcher* dispatcher );

    void            HK_CALL registerAgent3  ( hkpCollisionDispatcher* dispatcher );

    void            HK_CALL initAgentFunc   ( hkpCollisionDispatcher::Agent3Funcs& f );

        //
        // Other functions needed for shape-collection agents
        //

    void            HK_CALL updateFilter( hkpAgentEntry* entry, hkpAgentData* agentData, const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpContactMgr* mgr, hkCollisionConstraintOwner& constraintOwner );

    void            HK_CALL invalidateTim( hkpAgentEntry* entry, hkpAgentData* agentData, const hkpCollisionInput& input );

    void            HK_CALL warpTime( hkpAgentEntry* entry, hkpAgentData* agentData, hkTime oldTime, hkTime newTime, const hkpCollisionInput& input );


        //
        // Helper functions
        //

    HK_INLINE hkConvexListAgent3Data* HK_CALL getConvexListaData(const hkpAgentEntry* entry, hkpAgentData* data);

    HK_INLINE hkPredGskAgent3Data* HK_CALL getPredGskData(const hkpAgentEntry* entry, hkpAgentData* data);

    HK_INLINE void switchToStreamMode( const hkpAgent3ProcessInput& input, hkpAgentEntry* entry, hkpAgentData* agentData, hkpProcessCollisionOutput& output );

    HK_INLINE void switchToGskMode(const hkpAgent3ProcessInput& input, hkpAgentEntry* entry, hkpAgentData* agentData, hkpProcessCollisionOutput& output);

    HK_INLINE hkBool32 isInGskMode(const hkpAgentData* data);

    // used by saving contact points
    hkpAgent1nTrack* getAgent1nTrack(const hkpAgentEntry* entry, hkpAgentData* data);

    const hkpAgent1nTrack* getAgent1nTrack(const hkpAgentEntry* entry, const hkpAgentData* data);
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
