// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Physics/hkStepInfo.h>
#include <Physics2012/Collide/Agent/hkpCollisionInput.h>
#include <Physics2012/Collide/Agent3/Machine/1n/hkpAgent1nTrack.h>

#if defined(HK_PLATFORM_HAS_SPU)
#   include <Physics2012/Collide/Agent3/Machine/Nn/hkpAgentNnMachine.h>
#endif

struct hkpAgent1nSector;
struct hkpCollisionQualityInfo;

struct hkpAgent1nSector;

    /// This structure is used for all process collision calls queries.
struct HK_EXPORT_PHYSICS_2012 hkpProcessCollisionInput : public hkpCollisionInput
{
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpProcessCollisionInput);

    public:
        hkpProcessCollisionInput(): m_spareAgentSector(HK_NULL) {}

        inline ~hkpProcessCollisionInput();

#if !defined(HK_PLATFORM_SPU)
        hkpProcessCollisionInput& operator=(const hkpProcessCollisionInput& other)
        {
            // copy everything but m_spareAgentSector
            (hkpCollisionInput&)*this = (hkpCollisionInput&)other;
            m_stepInfo = other.m_stepInfo;
            m_collisionQualityInfo = other.m_collisionQualityInfo;
            m_dynamicsInfo = other.m_dynamicsInfo;
            m_enableDeprecatedWelding = other.m_enableDeprecatedWelding;
            m_allowToSkipConfirmedCallbacks = other.m_allowToSkipConfirmedCallbacks;
            m_config = other.m_config;
            return *this;
        }

        hkpProcessCollisionInput( const hkpProcessCollisionInput& other )
        :   hkpCollisionInput(other),
            m_spareAgentSector(HK_NULL)
        {
            *this = other;
        }

#endif

    public:
            /// time step information
        hkStepInfo m_stepInfo;

            /// A pointer to the collision quality information. See hkpCollisionDispatcher for more details
        mutable hkpCollisionQualityInfo* m_collisionQualityInfo;

#if defined(HK_PLATFORM_HAS_SPU)
        struct hkpSpuAgentSectorJobCollisionObjects* m_collisionObjects;
#endif
            /// An extra spare sector to optimize memory for the 1n Machine
        mutable hkpAgent1nSector*   m_spareAgentSector;

            /// a pointer to hkpWorldDynamicsStepInfo if you use the hkDynamics lib, otherwise this can be used as a user pointer
        void*   m_dynamicsInfo;

        hkBool m_enableDeprecatedWelding;

            /// On PlayStation(R)3 contact point confirmed callbacks can be omitted when bodies have zero restitution.
            /// Leave this set to false, to ensure all confirmed callbacks are consistent.
        hkBool m_allowToSkipConfirmedCallbacks;

            /// A pointer to a structure containing internal collision tolerances etc.
        hkpCollisionAgentConfig* m_config;

};

hkpProcessCollisionInput::~hkpProcessCollisionInput()
{
    if (m_spareAgentSector)
    {
        // Can't do as it causes compile error.. so this replaces it
        //delete m_spareAgentSector;

        HK_MEMORY_TRACKER_REMOVE(m_spareAgentSector);
        hkMemHeapBlockFree<void>(m_spareAgentSector, hkpAgent1nSector::SECTOR_SIZE);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
