// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline int hkpProcessCollisionData::getNumContactPoints() const
{
    return int(m_firstFreeContactPoint - &m_contactPoints[0]);
}

inline hkpProcessCdPoint* hkpProcessCollisionData::getFirstContactPoint()
{
    return &m_contactPoints[0];
}

inline hkpProcessCdPoint* hkpProcessCollisionData::getEnd()
{
    return m_firstFreeContactPoint;
}

inline hkpProcessCdPoint& hkpProcessCollisionData::getContactPoint( int i )
{
    return m_contactPoints[i];
}

inline hkBool hkpProcessCollisionData::isEmpty() const
{
    return m_firstFreeContactPoint == &m_contactPoints[0];
}

inline hkBool hkpProcessCollisionData::hasToi() const
{
    return m_toi.m_time != HK_REAL_MAX;
}

inline hkContactPoint& hkpProcessCollisionData::getToiContactPoint()
{
    return m_toi.m_contactPoint;
}

inline hkTime hkpProcessCollisionData::getToi() const
{
    return m_toi.m_time;
}

inline hkpContactPointProperties& hkpProcessCollisionData::getToiProperties()
{
    return m_toi.m_properties;
}


hkpProcessCollisionData::ToiInfo::ToiInfo() : m_time( HK_REAL_MAX )
{
}

hkpProcessCollisionData::hkpProcessCollisionData( hkCollisionConstraintOwner* owner )
{
    m_constraintOwner = owner;
}


void hkpProcessCollisionData::ToiInfo::flip()
{
    hkVector4 norm = m_contactPoint.getSeparatingNormal();
    norm.setNeg<3>( norm );
    m_contactPoint.setSeparatingNormal(norm);
    m_gskCache.flip();
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
