// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Physics/ContactPoint/hkContactPoint.h>


/// A contact point and associated ID. This structure is used internally by hkDynamics.
struct HK_EXPORT_PHYSICS_2012 hkpProcessCdPoint
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpProcessCdPoint);

    enum Type
    {
        TYPE_CLOSEST,   ///< This point is the closest point between two convex subshapes in this manifold,
        TYPE_OTHER,     ///< This point is not the closest but still there to produce a stable manifold.
        TYPE_UNSPECIFIED, ///< The collision agent does not support finding the closest point.
    };

        /// contact point
    HK_ALIGN(hkContactPoint m_contact, 16);

        /// contact point ID
    hkUint32 m_contactPointId;
    hkUint32 m_isShortestPoint; ///< see Type. This can't be a hkEnum or it will cause the struct to become non-POD
    hkUint32 m_padding[2];
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
