// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpCollisionDispatcher;
class hkpCollisionFilter;
class hkpConvexListFilter;
struct hkpCollisionAgentConfig;
class hkpSpuCollisionQueryDispatcher;


    /// The basic structure needed for all hkpCollisionAgent queries.
struct HK_EXPORT_PHYSICS_2012 hkpCollisionInput
{

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpCollisionInput);

    public:

            /// Get the collision tolerance
        hkReal getTolerance() const { return m_tolerance; }

            /// Set the collision tolerance
        void setTolerance(hkReal t) { m_tolerance = t; }

    public:

        hkpCollisionInput() : m_forceAcceptContactPoints(false) {}


            /// A pointer to the collision dispatcher, needed if more agents need to be created to complete the query
        hkpCollisionDispatcher* m_dispatcher;

#if defined(HK_PLATFORM_HAS_SPU)
            // this is a special spu version of the dispatcher for collision queries that is only set and used on the spu
        hkpSpuCollisionQueryDispatcher* m_queryDispatcher;
#endif

            /// Used to weld normals obtained from getClosestPoints functions
        hkBool32 m_weldClosestPoints;

            /// Internal -- if we are linear casting, don't allow welding to reject contact points
        hkBool32 m_forceAcceptContactPoints;

            /// The collision tolerance. Only points closer than this tolerance will be reported.
        hkReal m_tolerance;

            /// The filter used if any shape collections are queried. This filter will be called before any child shapes
            /// are considered for the query.
        const hkpCollisionFilter* m_filter;

            /// A filter used to decide how to treat convex list shapes in collisions.
        const hkpConvexListFilter* m_convexListFilter;

            /// Only used when you create persistent agents
        mutable hkBool32 m_createPredictiveAgents;

        struct Aabb32Info
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkpCollisionInput::Aabb32Info );

            hkVector4 m_bitOffsetLow;
            hkVector4 m_bitOffsetHigh;
            hkVector4 m_bitScale;
        };

        Aabb32Info m_aabb32Info;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
