// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent/hkpProcessCollisionOutput.h>
#include <Physics2012/Collide/Agent/Query/hkpCdPointCollector.h>
#include <Physics2012/Collide/Agent/Query/hkpCdBodyPairCollector.h>

class hkpCdBody;
struct hkpCollisionInput;
class hkpContactMgr;


    /// A special symmetric agent, which should be used instead of the hkpSymmetricAgent if you derive
    /// the agent from the hkpIterativeLinearCastAgent
template<typename AGENT>
class hkpSymmetricAgentLinearCast : public AGENT
{
    public:

        HK_INLINE hkpSymmetricAgentLinearCast( hkpContactMgr* mgr ): AGENT(mgr){}

            /// Called by the appropriate createAgent() function.
        HK_INLINE hkpSymmetricAgentLinearCast( const hkpCdBody& A, const hkpCdBody& B, const hkpCollisionInput& input, hkpContactMgr* mgr );

            // hkpCollisionAgent interface implementation.
        virtual void getPenetrations( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpCdBodyPairCollector& collector );

            // hkpCollisionAgent interface implementation.
        static void HK_CALL staticGetPenetrations( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpCdBodyPairCollector& collector );

            // hkpCollisionAgent interface implementation.
        virtual void getClosestPoints( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, class hkpCdPointCollector& collector  ) ;


            // hkpCollisionAgent interface implementation.
        static void HK_CALL staticGetClosestPoints( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, class hkpCdPointCollector& collector  ) ;

            // hkpCollisionAgent interface implementation.
        static void HK_CALL staticLinearCast( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpLinearCastCollisionInput& input, hkpCdPointCollector& collector, hkpCdPointCollector* startCollector );

            // hkpCollisionAgent interface forward call.
        virtual void processCollision(  const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpProcessCollisionInput& input, hkpProcessCollisionOutput& result);

            // hkpCollisionAgent interface forward call.
        virtual void updateShapeCollectionFilter( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkCollisionConstraintOwner& constraintOwner );

};

/// a private class to hkpSymmetricAgent, declared outside, as this class is not templated
class HK_EXPORT_PHYSICS_2012 hkpSymmetricAgentFlipCollector: public hkpCdPointCollector
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpCdPointCollector);
        hkpCdPointCollector& m_collector;
        hkpSymmetricAgentFlipCollector( hkpCdPointCollector& c): m_collector(c){}
        virtual void addCdPoint( const hkpCdPoint& point );
};

/// a private class to hkpSymmetricAgent, declared outside, as this class is not templated
class HK_EXPORT_PHYSICS_2012 hkpSymmetricAgentFlipCastCollector: public hkpCdPointCollector
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpSymmetricAgentFlipCastCollector);
        hkVector4 m_path;
        hkpCdPointCollector& m_collector;

        hkpSymmetricAgentFlipCastCollector( const hkVector4& path, hkpCdPointCollector& c): m_path(path), m_collector(c){}
        virtual void addCdPoint( const hkpCdPoint& point );
};

/// a private class to hkpSymmetricAgent, declared outside, as this class is not templated
class HK_EXPORT_PHYSICS_2012 hkpSymmetricAgentFlipBodyCollector: public hkpCdBodyPairCollector
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpSymmetricAgentFlipBodyCollector);
        hkpCdBodyPairCollector& m_collector;
        hkpSymmetricAgentFlipBodyCollector( hkpCdBodyPairCollector& c): m_collector(c){}
        virtual void addCdBodyPair( const hkpCdBody& bodyA, const hkpCdBody& bodyB);
};


#include <Physics2012/Collide/Agent/Util/Symmetric/hkpSymmetricAgentLinearCast.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
