// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

/***
 *** INLINE FUNCTION DEFINITIONS
 ***/




template<typename AGENT>
inline hkpSymmetricAgent<AGENT>::hkpSymmetricAgent( const hkpCdBody& A, const hkpCdBody& B, const hkpCollisionInput& input, hkpContactMgr* mgr )
:   hkpSymmetricAgentLinearCast<AGENT>( A, B, input, mgr )
{
}



template<typename AGENT>
void hkpSymmetricAgent<AGENT>::linearCast( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpLinearCastCollisionInput& input, hkpCdPointCollector& collector, hkpCdPointCollector* startCollector )
{
    hkpLinearCastCollisionInput flippedInput = input;
    flippedInput.m_path.setNeg<4>( input.m_path );

    hkpSymmetricAgentFlipCastCollector flip( input.m_path, collector );
    if ( startCollector )
    {
        hkpSymmetricAgentFlipCastCollector startFlip( input.m_path, *startCollector );
        AGENT::linearCast(bodyB, bodyA, flippedInput, flip, &startFlip );
    }
    else
    {
        AGENT::linearCast(bodyB , bodyA , flippedInput, flip, HK_NULL );
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
