// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


class hkpCdBody;

    /// This class is used as an interface to the collision detector ( e.g., getPenetrations() )
    /// to collect pairs of hkpCdBody
class HK_EXPORT_PHYSICS_2012 hkpCdBodyPairCollector
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpCdBodyPairCollector);

            /// Default constructor calls reset(), initializing the early out variable to false.
        inline hkpCdBodyPairCollector();

        inline virtual ~hkpCdBodyPairCollector();

            /// This is the function called for every hit of the collision detector.
            /// Note: for optimization purposes this should set the m_earlyOut:
            /// - true if you want to get no more hits
            /// - false if you want to get more hits (which is the default)
        virtual void addCdBodyPair( const hkpCdBody& bodyA, const hkpCdBody& bodyB ) = 0;

            /// resets m_earlyOut to false. You must call this function if you want to reuse an object of this class.
        inline virtual void reset();

            /// Gets the early out, if true, no more CdBodyPairs are reported
        inline hkBool getEarlyOut( ) const;

    protected:

        hkBool m_earlyOut;

};

#include <Physics2012/Collide/Agent/Query/hkpCdBodyPairCollector.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
