// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent/Util/LinearCast/hkpIterativeLinearCastAgent.h>

    /// This agent performs the collision between a set of spheres and a 3 dimensional function
class HK_EXPORT_PHYSICS_2012 hkpFullManifoldAgent : public hkpCollisionAgent
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// register the this agent with everything
        static void HK_CALL registerAgent(hkpCollisionDispatcher* dispatcher);

            // hkpCollisionAgent interface implementation.
        virtual inline void processCollision(const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpProcessCollisionInput& input, hkpProcessCollisionOutput& result);

            // hkpCollisionAgent interface implementation.
        virtual void getPenetrations(const  hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpCdBodyPairCollector& collector );

            // hkpCollisionAgent interface implementation.
        static void HK_CALL staticGetPenetrations(const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpCdBodyPairCollector& collector );

            // hkpCollisionAgent interface implementation.
        virtual void getClosestPoints( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpCdPointCollector& collector);

            // hkpCollisionAgent interface implementation.
        static void HK_CALL staticGetClosestPoints( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, class hkpCdPointCollector& collector  );


        virtual void linearCast( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpLinearCastCollisionInput& input, hkpCdPointCollector& collector, hkpCdPointCollector* startCollector );

        static void HK_CALL staticLinearCast( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpLinearCastCollisionInput& input, hkpCdPointCollector& collector, hkpCdPointCollector* startCollector );


            /// hkAgent interface implementation
        void destroyContactPoints( hkCollisionConstraintOwner& constraintOwner );
        virtual void cleanup( hkCollisionConstraintOwner& constraintOwner );



    protected:
            /// Constructor, called by the createXXX functions
        hkpFullManifoldAgent(const hkpCdBody& A,const  hkpCdBody& B,const  hkpCollisionInput& input, hkpContactMgr* mgr);

            /// Destructor
        ~hkpFullManifoldAgent(){}

    protected:
            /// create functions, known by the hkpCollisionDispatcher
        static hkpCollisionAgent* HK_CALL createFullManifoldAgent( const hkpCdBody& A, const hkpCdBody& B, const hkpCollisionInput& input, hkpContactMgr* mgr );

        struct ContactPoint
        {
            int m_feature;
            hkContactPointId m_contactPointId;
        };

        hkArray<ContactPoint> m_contactPointIds;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
