// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Internal/Collide/Gjk/GskManifold/hkpGskManifold.h>
#include <Physics2012/Collide/Agent/ConvexAgent/Gjk/hkpGskBaseAgent.h>
#include <Physics2012/Collide/Dispatch/hkpCollisionDispatcher.h>

class hkpCollisionDispatcher;
struct hkpExtendedGskOut;

    /// The hkpGskfAgent is an hkpGskBaseAgent agent which uses a highly optimized
    /// feature based manifold. This manifold works really well for big triangles
    /// and has no parameters to tune
class HK_EXPORT_PHYSICS_2012 hkpGskfAgent : public hkpGskBaseAgent
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
#if !defined(HK_PLATFORM_SPU)
        static void HK_CALL initAgentFunc(hkpCollisionDispatcher::AgentFuncs& f);
#else
        static void HK_CALL initAgentFunc(hkpSpuCollisionQueryDispatcher::AgentFuncs& f);
#endif

            /// Registers the agent with the collision dispatcher.
        static void HK_CALL registerAgent(hkpCollisionDispatcher* dispatcher);

            // hkpCollisionAgent interface implementation.
        virtual void processCollision(const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpProcessCollisionInput& input, hkpProcessCollisionOutput& result);

            // hkpCollisionAgent interface implementation.
        virtual void cleanup( hkCollisionConstraintOwner& constraintOwner );

            // hkpCollisionAgent interface implementation.
        virtual void removePoint( hkContactPointId idToRemove );

            // hkpCollisionAgent interface implementation.
        virtual void commitPotential( hkContactPointId newId );

            // hkpCollisionAgent interface implementation.
        virtual void createZombie( hkContactPointId idTobecomeZombie );

    protected:

        friend class hkpConvexConvexWelderAgent;

            //
            // Note: to use the next two inline functions include the .inl file
            //
            /// Constructor, called by the createGskConvexConvexAgent() function.
        hkpGskfAgent(const hkpCdBody& bodyA, const hkpCdBody& bodyB, hkpContactMgr* mgr);

        /// Destructor, called by cleanup().
        ~hkpGskfAgent(){}

            // hkpCollisionAgent interface implementation.
        void processCollisionNoTim(const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpProcessCollisionInput& input, int explicitlyAllowNewPoint, hkpProcessCollisionOutput& result);

    public:
        /// Agent creation function used by the hkpCollisionDispatcher.
        static hkpCollisionAgent* HK_CALL createGskfAgent(const     hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpContactMgr* mgr);

    protected:
    public:
        hkpGskManifold m_manifold;

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
