// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent/hkpCollisionAgent.h>
#include <Physics2012/Collide/Dispatch/hkpCollisionDispatcher.h>
#include <Physics2012/Collide/Agent3/Machine/1n/hkpAgent1nTrack.h>

class hkpCollisionDispatcher;


/// This agent handles collisions between hkListShapes and other shapes. An hkpListAgent gets
/// further agents from the dispatcher to handle collisions for each of the list shape's child shapes.
class HK_EXPORT_PHYSICS_2012 hkpListAgent : public hkpCollisionAgent
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
#if !defined(HK_PLATFORM_SPU)
        static void HK_CALL initAgentFunc       (hkpCollisionDispatcher::AgentFuncs& f);
        static void HK_CALL initAgentFuncInverse(hkpCollisionDispatcher::AgentFuncs& f);
#else
        static void HK_CALL initAgentFunc       (hkpSpuCollisionQueryDispatcher::AgentFuncs& f);
        static void HK_CALL initAgentFuncInverse(hkpSpuCollisionQueryDispatcher::AgentFuncs& f);
#endif

            /// Registers this agent with the collision dispatcher.
        static void HK_CALL registerAgent(hkpCollisionDispatcher* dispatcher);

            // hkpCollisionAgent interface implementation.
        virtual void processCollision(const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpProcessCollisionInput& input, hkpProcessCollisionOutput& output);

            // hkpCollisionAgent interface implementation.
        virtual void linearCast( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpLinearCastCollisionInput& input, hkpCdPointCollector& collector, hkpCdPointCollector* startCollector );

            // hkpCollisionAgent interface implementation.
        static void HK_CALL staticLinearCast( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpLinearCastCollisionInput& input, hkpCdPointCollector& collector, hkpCdPointCollector* startCollector );

            // hkpCollisionAgent interface implementation.
        virtual void getClosestPoints( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpCdPointCollector& pointDetails);

            // hkpCollisionAgent interface implementation.
        static void HK_CALL staticGetClosestPoints( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, class hkpCdPointCollector& collector  );

            /// hkpCollisionAgent interface implementation.
        virtual void getPenetrations(const  hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpCdBodyPairCollector& collector );

            // hkpCollisionAgent interface implementation.
        static void HK_CALL staticGetPenetrations( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpCdBodyPairCollector& collector );

            // hkpCollisionAgent interface implementation.
        virtual void updateShapeCollectionFilter( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkCollisionConstraintOwner& constraintOwner );

            // hkpCollisionAgent interface implementation.
        virtual void invalidateTim( const hkpCollisionInput& input);

            // hkpCollisionAgent interface implementation.
        virtual void warpTime(hkTime oldTime, hkTime newTime, const hkpCollisionInput& input);

            // hkpCollisionAgent interface implementation.
        virtual void cleanup(hkCollisionConstraintOwner& info);

    public:

        /// Constructor, called by the agent creation functions.
        hkpListAgent( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpContactMgr* mgr);

        /// Agent creation function used by the hkpCollisionDispatcher.
        static hkpCollisionAgent* HK_CALL createListAAgent(const    hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpContactMgr* contactMgr);

        /// Agent creation function used by the hkpCollisionDispatcher.
        static hkpCollisionAgent* HK_CALL createListBAgent( const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpContactMgr* contactMgr);

    protected:

        hkpCollisionDispatcher* m_dispatcher;

        hkpAgent1nTrack  m_agentTrack;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
