// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent/CompoundAgent/BvTree/hkpBvTreeAgent.h>

class hkpCollisionDispatcher;

/// Agent used to handle collisions with hkpStaticCompoundShape
class HK_EXPORT_PHYSICS_2012 hkpStaticCompoundAgent : public hkpBvTreeAgent
{
    public:

        enum
        {
            // Maximum number of results that can be obtained from an AABB query
#if !defined(HK_PLATFORM_HAS_SPU)
            HK_MAX_NUM_HITS_PER_AABB_QUERY = 2048
#else
            HK_MAX_NUM_HITS_PER_AABB_QUERY = 1024
#endif
        };

    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

            /// Registers this agent with the collision dispatcher
        static void HK_CALL registerAgent(hkpCollisionDispatcher* dispatcher);

            /// Used by the collision dispatcher to create an agent for collisions between a shape of any type and a hkpBvCompressedMeshShape
        static hkpCollisionAgent* HK_CALL createShapeVsStaticCompoundAgent(const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpContactMgr* mgr);

            /// Used by the collision dispatcher to create an agent for collisions between a hkpBvCompressedMeshShape and a shape of any type
        static hkpCollisionAgent* HK_CALL createStaticCompoundVsShapeAgent(const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpContactMgr* mgr);

            /// Used by the collision dispatcher to create an agent for collisions between two hkpBvCompressedMeshShape shapes
        static hkpCollisionAgent* HK_CALL createStaticCompoundVsStaticCompoundAgent(const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpCollisionInput& input, hkpContactMgr* mgr);


        /////////////////////////////////
        // hkpCollisionAgent interface

            /// hkpCollisionAgent interface implementation, refer to that class for details
        virtual void linearCast(const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpLinearCastCollisionInput& input, hkpCdPointCollector& collector, hkpCdPointCollector* startCollector);

            /// Static version of linearCast for its use in dispatchers
        static void HK_CALL staticLinearCast(const hkpCdBody& bodyA, const hkpCdBody& bodyB, const hkpLinearCastCollisionInput& input, hkpCdPointCollector& collector, hkpCdPointCollector* startCollector);

    #if defined(HK_PLATFORM_SPU)

            /// Initializes the agent functions in a hkpSpuCollisionQueryDispatcher
        static void HK_CALL initAgentFunc(hkpSpuCollisionQueryDispatcher::AgentFuncs& f);

            /// Initializes the inverse agent functions in a hkpSpuCollisionQueryDispatcher
        static void HK_CALL initAgentFuncInverse(hkpSpuCollisionQueryDispatcher::AgentFuncs& f);

    #endif

    protected:

            /// Constructor, called by the agent creation function.
        hkpStaticCompoundAgent(hkpContactMgr* mgr);
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
