// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>

inline hkpCollidable::hkpCollidable(const hkpShape* shape, const hkMotionState* ms, int type)
:   hkpCdBody(shape, ms), m_ownerOffset(0),
        m_broadPhaseHandle(type),
        m_allowedPenetrationDepth(hkReal(-1))
{
    m_broadPhaseHandle.setOwner(this); // 'this' valid here.
#ifdef HK_DEBUG
    checkPerformance();
#endif
}

inline hkpCollidable::hkpCollidable(const hkpShape* shape, const hkTransform* t, int type)
:   hkpCdBody(shape, t) , m_ownerOffset(0),
    m_broadPhaseHandle(type),
    m_allowedPenetrationDepth(hkReal(-1))
{
    m_broadPhaseHandle.setOwner(this); // 'this' valid here.
#ifdef HK_DEBUG
    //checkPerformance();   // this will produce 10 million warnings in the filter pipeline
#endif
}

inline void hkpCollidable::afterReflectNew()
{
    m_broadPhaseHandle.setOwner(this);
}

void hkpCollidable::BoundingVolumeData::afterReflectNew()
{
    if (m_numChildShapeAabbs != 0 || m_capacityChildShapeAabbs != 0 || m_childShapeAabbs != HK_NULL || m_childShapeKeys != HK_NULL)
    {
        HK_WARN_ONCE(0xad836432, "Cached AABBs were saved in a packfile!?");
    }
    m_numChildShapeAabbs = 0;
    m_capacityChildShapeAabbs = 0;
    m_childShapeAabbs = HK_NULL;
    m_childShapeKeys = HK_NULL;
    invalidate();
}

HK_INLINE bool hkpCollidable::BoundingVolumeData::hasAllocations() const
{
    HK_ASSERT(0xad808121, ((m_childShapeAabbs != HK_NULL) == (m_childShapeKeys != HK_NULL)) && ((m_childShapeAabbs != HK_NULL) == (m_capacityChildShapeAabbs != 0)), "BoundingVolumeData sub-allocations incorrect");
    return HK_NULL != m_childShapeAabbs;
}


HK_INLINE hkpCollidable::~hkpCollidable()
{
}

HK_INLINE void hkpCollidable::setShape(const hkpShape* shape)
{
    m_shape          = shape;

#if defined(HK_PLATFORM_HAS_SPU)
    setShapeSizeForSpu();
#endif

    // Just duplicating the constructor behavior, checking if the new m_shape might cause
    // performance loss.
#if defined HK_DEBUG && !defined(HK_PLATFORM_HAS_SPU)
    checkPerformance();
#endif
}

HK_INLINE const hkpShape* hkpCollidable::getShape() const
{
    return m_shape;
}

// HK_INLINE void* hkpCollidable::getOwner() const
// {
//  return const_cast<char*>( reinterpret_cast<const char*>(this) + m_ownerOffset );
// }

HK_INLINE void hkpCollidable::setOwner( void* owner )
{
    int ownerOffset = hkGetByteOffsetInt( this, owner ); // should be within int8 range even on 64 bit as a member
    HK_ASSERT_NO_MSG( 0xf0232323, ownerOffset > -128 && ownerOffset<127);
    m_ownerOffset = hkInt8(ownerOffset);
}

inline const hkpTypedBroadPhaseHandle* hkpCollidable::getBroadPhaseHandle() const
{
    return &m_broadPhaseHandle;
}

inline hkpTypedBroadPhaseHandle* hkpCollidable::getBroadPhaseHandle()
{
    return &m_broadPhaseHandle;
}

int hkpCollidable::getType() const
{
    return m_broadPhaseHandle.getType();
}

HK_INLINE hkpCollidableQualityType hkpCollidable::getQualityType() const
{
    return hkpCollidableQualityType( m_broadPhaseHandle.m_objectQualityType );
}

HK_INLINE void hkpCollidable::setQualityType(hkpCollidableQualityType type)
{
    m_broadPhaseHandle.m_objectQualityType = hkInt8(type);
}

hkUint32 hkpCollidable::getCollisionFilterInfo() const
{
    return m_broadPhaseHandle.getCollisionFilterInfo();
}

void hkpCollidable::setCollisionFilterInfo( hkUint32 info )
{
    m_broadPhaseHandle.setCollisionFilterInfo(info);
}


HK_INLINE hkReal hkpCollidable::getAllowedPenetrationDepth() const
{
    return m_allowedPenetrationDepth;
}

HK_INLINE void hkpCollidable::setAllowedPenetrationDepth( hkReal val )
{
    HK_ASSERT(0xad45bd3d, val > HK_REAL_EPSILON, "Must use a non-zero ( > epsilon ) value when setting allowed penetration depth of bodies.");
    m_allowedPenetrationDepth = val;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
