  // TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Shape/hkpShape.h>
#include <Physics2012/Collide/Shape/Compound/Collection/List/hkpListShape.h>
#include <Physics2012/Collide/Shape/Compound/Collection/hkpShapeCollection.h>

hkBool hkpCollidable::checkPerformance()
{
    if(!m_shape)
    {
        return false;
    }

    // THE CHECKS BELOW ARE DUPLICATED IN hkpRigidBody::checkPerformance() TO BE SUPER SAFE. IF YOU CHANGE/ADD STUFF HERE
    // PLEASE SEE IF YOU NEED TO ALSO DO THE SAME IN hkpRigidBody::checkPerformance()

    hkBool isOk = true;
    const int manyChildren = 100;

    // List (with many children)
    if( m_shape->getType() == hkcdShapeType::LIST
        && static_cast<const hkpListShape*>(m_shape)->getNumChildShapes() > manyChildren )
    {
        HK_WARN(0x2ff8c16c, "Collidable at address " << this << " has an hkpListShape with > " << manyChildren << " children.\n" \
            "This can cause a significant performance loss when the shape is collided e.g. with another complex hkpListShape.\n" \
            "When using hkpListShape with many children consider using building an hkpMoppBvTreeShape around it.\n");
        isOk = false;
    }

    // Mesh (without MOPP)
    if( m_shape->getType() == hkcdShapeType::TRIANGLE_COLLECTION && static_cast<const hkpShapeCollection*>(m_shape)->getNumChildShapes() > manyChildren )
    {
        HK_WARN(0x2ff8c16e, "Collidable at address " << this << " has a mesh shape.\n" \
            "This can cause a significant performance loss.\n" \
            "The collection of triangle shapes (hkpMeshShape) should not be used for dynamic bodies.\n" \
            "You should consider building an hkpMoppBvTreeShape around the mesh.\n");
        isOk = false;
    }

    // Collection (without MOPP)
    if( (m_shape->getType() == hkcdShapeType::COLLECTION || m_shape->getType() == hkcdShapeType::TRI_SAMPLED_HEIGHT_FIELD_COLLECTION)
        && static_cast<const hkpShapeCollection*>(m_shape)->getNumChildShapes() > manyChildren )
    {
        HK_WARN(0x578cef50, "Collidable at address " << this << " has a shape collection without a hkpBvTreeShape.\n" \
            "This can cause performance loss. To avoid getting this message\n" \
            "add a hkpBvTreeShape above this shape.");
        isOk = false;
    }

    // Transformed shape
    if( m_shape->getType() == hkcdShapeType::TRANSFORM)
    {
        HK_WARN(0x2ff8c16f, "Collidable at address " << this << " has a transform shape as the root shape.\n" \
                "This can cause a significant performance loss. To avoid getting this message\n" \
                "compose the transform into the collidable and remove the transform shape.\n" \
                "Please see the 'hkpTransformShape' documentation in the User Guide for more information.\n");
        isOk = false;
    }

    return isOk;
}


hkpCollidable::BoundingVolumeData::BoundingVolumeData()
{
    hkString::memSet( this, 0, sizeof(*this) );
    invalidate();
}


void hkpCollidable::BoundingVolumeData::deallocate()
{
    HK_ASSERT(0xaf35fe31, hasAllocations(), "Deallocating non-existent structure.");
    hkDeallocateChunk(m_childShapeAabbs, m_capacityChildShapeAabbs, HK_MEMORY_CLASS_COLLIDE);
    hkDeallocateChunk(m_childShapeKeys, HK_NEXT_MULTIPLE_OF(16/sizeof(hkpShapeKey),m_capacityChildShapeAabbs), HK_MEMORY_CLASS_COLLIDE);
    m_childShapeAabbs    = HK_NULL;
    m_childShapeKeys    = HK_NULL;
    m_numChildShapeAabbs = 0;
    m_capacityChildShapeAabbs = 0;
}

void hkpCollidable::BoundingVolumeData::allocate(int numChildShapes)
{
    HK_ASSERT(0xad808123, !hasAllocations(), "Structure already has allocation.");
    HK_ASSERT(0xad808124, numChildShapes <= hkUint16(-1), "Too many child shapes (maximum = 2^16). Did you forget to wrap a shape collection with a MOPP?" );
    m_numChildShapeAabbs = hkUint16(numChildShapes);
    m_capacityChildShapeAabbs = hkUint16(numChildShapes);
    if ( numChildShapes )
    {
        m_childShapeAabbs    = hkAllocateChunk<hkAabbUint32>(m_capacityChildShapeAabbs, HK_MEMORY_CLASS_COLLIDE);
        m_childShapeKeys     = hkAllocateChunk<hkpShapeKey>( HK_NEXT_MULTIPLE_OF(16/sizeof(hkpShapeKey),m_capacityChildShapeAabbs), HK_MEMORY_CLASS_COLLIDE);
    }
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
