// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/hkpConstraintExport.h>

/// Constraint solver results. This class is used internally by the system, however it may be used to query the results
/// of the constraint solver for this constraint on the last solve() call.
class HK_EXPORT_PHYSICS hkpSolverResults
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpSolverResults );

        /// Get the impulse applied by the solver on the last time step. This structure may be returned prior to the application of the
        /// constraint solver. For the case of a contact constraint it is initialized to a very crude guess at the expected initial impulse.
        HK_INLINE hkReal getImpulseApplied() const;

        // internal use only
        HK_INLINE hkpSolverResults();

        // internal use only
        HK_INLINE void init();

    public:

        // internal use only
        hkReal m_impulseApplied;

        // internal use only
        hkReal m_internalSolverData;
};

#include <Physics/ConstraintSolver/Solve/hkpSolverResults.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
