// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/ConstraintSolver/Jacobian/hkpJacobianSchema.h>

#include <Physics/ConstraintSolver/Jacobian/hkpJacobianElement.h>
#include <Physics/ConstraintSolver/Accumulator/hkpVelocityAccumulator.h>
#include <Physics/ConstraintSolver/Solve/hkpSolverResults.h>

class hkpSolverResults;
class hkpConstraintInstance;


///
class HK_EXPORT_PHYSICS hkpJacobianHeaderSchema
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpJacobianHeaderSchema );

        HK_INLINE void initHeader( _In_opt_ hkpConstraintInstance* instance, const int bodyAIndex, const int bodyBIndex, _In_opt_ hkpSolverResults* sr, const int solverResultStriding );

        HK_INLINE hkpVelocityAccumulator* getBodyA   ( _In_reads_(m_bodyAIndex + 1) hkpVelocityAccumulator* accumulatorBuffer ) const { return accumulatorBuffer + m_bodyAIndex; }
        HK_INLINE hkpVelocityAccumulator* getBodyB   ( _In_reads_(m_bodyBIndex + 1) hkpVelocityAccumulator* accumulatorBuffer ) const { return accumulatorBuffer + m_bodyBIndex; }

        HK_INLINE hkpVelocityAccumulator* getBodyA( _In_reads_(m_bodyAIndex + 1) const hkUint16* interIndices, /*no idea how to annotate this*/ hkpVelocityAccumulator* accumulatorBuffer) const { return accumulatorBuffer + interIndices[m_bodyAIndex]; }
        HK_INLINE hkpVelocityAccumulator* getBodyB( _In_reads_(m_bodyBIndex + 1) const hkUint16* interIndices, /*no idea how to annotate this*/ hkpVelocityAccumulator* accumulatorBuffer) const { return accumulatorBuffer + interIndices[m_bodyBIndex]; }

        HK_INLINE const hkpVelocityAccumulator* getBodyA   ( _In_reads_(m_bodyAIndex + 1) const hkpVelocityAccumulator* accumulatorBuffer ) const { return accumulatorBuffer + m_bodyAIndex; }
        HK_INLINE const hkpVelocityAccumulator* getBodyB   ( _In_reads_(m_bodyBIndex + 1) const hkpVelocityAccumulator* accumulatorBuffer ) const { return accumulatorBuffer + m_bodyBIndex; }

        HK_INLINE const hkpVelocityAccumulator* getBodyA   ( _In_reads_(m_bodyAIndex + 1) const hkUint16* interIndices, /*no idea how to annotate this*/ const hkpVelocityAccumulator* accumulatorBuffer ) const { return accumulatorBuffer + interIndices[m_bodyAIndex]; }
        HK_INLINE const hkpVelocityAccumulator* getBodyB   ( _In_reads_(m_bodyBIndex + 1) const hkUint16* interIndices, /*no idea how to annotate this*/ const hkpVelocityAccumulator* accumulatorBuffer ) const { return accumulatorBuffer + interIndices[m_bodyBIndex]; }

    protected:

        HK_ALIGN_REAL(hkUint8 m_padding0); // Type stored here in little endian platforms

    public:

        hkUint8 m_solverResultStriding;

    protected:

        hkUint16 m_padding1; // Type stored here (actually in the last 8 bits) in big endian platform.
                             // Read hkpJacobianSchema.h for the full story.

#if defined(HK_REAL_IS_DOUBLE)
        hkUint32 m_padding2;
#endif

    public:

        hkUint16 m_bodyAIndex; // points to the local accumulator, or could be the number of
        hkUint16 m_bodyBIndex;

    public:

        hkpSolverResults*       m_solverResultInMainMemory;
        hkpConstraintInstance*  m_constraintInstance;   // this pointer is only set and used of the hkConstraintSolver library is used with the hkDynamics library
};

void hkpJacobianHeaderSchema::initHeader( _In_opt_ hkpConstraintInstance* instance, const int bodyAIndex, const int bodyBIndex, _In_opt_ hkpSolverResults* sr, int solverResultStriding )
{
    HK_SET_SCHEMA_TYPE(this, SCHEMA_TYPE_HEADER); // set the beginning init function when storing type in dedicated padding space

    m_bodyAIndex    = hkUint16(bodyAIndex);
    m_bodyBIndex    = hkUint16(bodyBIndex);

    m_solverResultInMainMemory = sr;
    m_constraintInstance = instance;

    // !! Note: initialize solverResultsStrinding after assigning type (assigning type modifies the first 4/8 bytes)
    HK_ASSERT(0xad789ddd, solverResultStriding < 0xf00, "Solver results striding to large.");
    HK_ASSERT(0xad7866dd, (solverResultStriding & (sizeof(hkReal)-1)) == 0, "Solver results striding not a multiple of native size of hkReal!");
    m_solverResultStriding = hkUint8(solverResultStriding);
}


///
class HK_EXPORT_PHYSICS hkpJacobianGotoSchema : public hkpJacobianSchemaInfo::Goto
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpJacobianGotoSchema );

        HK_INLINE void initGoto( _In_ hkpJacobianSchema* destination )
        {
            HK_SET_SCHEMA_TYPE(this, SCHEMA_TYPE_GOTO); // set the beginning init function when storing type in dedicated padding space
            m_offset = hkGetByteOffset( this, destination );
        }

        HK_INLINE void initOffset( hkLong offset )
        {
            HK_SET_SCHEMA_TYPE(this, SCHEMA_TYPE_GOTO); // set the beginning init function when storing type in dedicated padding space
            m_offset = offset;
        }

    public:

        HK_ALIGN_REAL(hkUint32 m_padding0); // type goes in here
        hkUint32 m_padding1;
        hkLong m_offset;
#if HK_POINTER_SIZE == 4
        hkUint32 m_padding2;
#endif
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
