// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/ConstraintSolver/Accumulator/hkpVelocityAccumulator.h>


///
class hkp2AngJacobian
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp2AngJacobian );

        HK_INLINE hkReal getEffMass() const                     {   return m_angular[0](3);                 }
        HK_INLINE hkSimdReal getEffMassSr() const               {   return m_angular[0].getComponent<3>();  }
        HK_INLINE void setEffMass( hkReal v )                   {   m_angular[0](3) = v;                    }
        HK_INLINE void setEffMass( hkSimdRealParameter v )      {   m_angular[0].setComponent<3>(v);        }

        HK_INLINE void setAngularRhs( hkReal v )                {   m_angular[1](3) = v;                    }
        HK_INLINE void setAngularRhs( hkSimdRealParameter v )   {   m_angular[1].setComponent<3>(v);        }
        HK_INLINE hkReal& getAngularRhs()                       {   return m_angular[1](3);                 }
        HK_INLINE hkReal getAngularRhs() const                  {   return m_angular[1](3);                 }
        HK_INLINE hkSimdReal getAngularRhsSr() const            {   return m_angular[1].getComponent<3>();  }
        HK_INLINE const hkSimdReal getRhsSr() const             {   return m_angular[1].getComponent<3>();  }

    //private:

        // Get the diag where |linear| = 0.0f and |angular| = 1.0f
        template<typename VEL>
        HK_INLINE hkSimdReal getAngularDiag( const VEL& mA, const VEL& mB ) const;

        HK_INLINE hkSimdReal getNonDiagOptimized(
            const hkpVelocityAccumulator& mA, const hkpVelocityAccumulator& mB, const hkp2AngJacobian& jacB ) const;

        HK_INLINE hkSimdReal getNonDiagSameObjects(
            const hkpVelocityAccumulator& mA, const hkpVelocityAccumulator& mB, const hkp2AngJacobian& jacB ) const;

        HK_INLINE hkSimdReal getNonDiagDifferentObjects_With2ndBodyFromFirstObject(
            const hkpVelocityAccumulator& mA, const hkp2AngJacobian& jacB ) const;

    public:

        // The angular part of the constraint
        //  angular[0].w component is the invJacDiag
        hkVector4 m_angular[2];
};


///
class hkp1Lin2AngJacobian
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp1Lin2AngJacobian );

        // This casts the Jacobian to a hkp2AngJacobian. Note that you cannot access its Rhs or AngularRhs values.
        // This requires that body hk2AngJac's and hk1Lin2AngJac's getEffMass() use the same variable in m_angular vectors .
        HK_INLINE hkp2AngJacobian& as2AngJacobian_internal() { return *reinterpret_cast<hkp2AngJacobian*>(&m_angular[0]); }

        // warning: call the next function only after setting the linear and angular part
        HK_INLINE void setRHS( hkReal v )                   {   m_linear0(3) = v;                   }
        HK_INLINE void setRHS( hkSimdRealParameter v )      {   m_linear0.setComponent<3>(v);       }
        HK_INLINE hkReal& getRHS()                          {   return m_linear0(3);                }
        HK_INLINE const hkReal& getRHS() const              {   return m_linear0(3);                }
        HK_INLINE const hkSimdReal getRhsSr() const         {   return m_linear0.getComponent<3>(); }

        HK_INLINE hkReal getEffMass() const                 {   return m_angular[0](3);                 }
        HK_INLINE hkSimdReal getEffMassSr() const           {   return m_angular[0].getComponent<3>();  }
        HK_INLINE void setEffMass( hkReal v )               {   m_angular[0](3) = v;                    }
        HK_INLINE void setEffMass( hkSimdRealParameter v )  {   m_angular[0].setComponent<3>(v);        }

        HK_INLINE hkReal getUserValue() const               {   return m_angular[1](3);                 }
        HK_INLINE hkSimdReal getUserValueSr() const         {   return m_angular[1].getComponent<3>();  }
        HK_INLINE void setUserValue( hkReal v )             {   m_angular[1](3) = v;                    }
        HK_INLINE void setUserValue( hkSimdRealParameter v ){   m_angular[1].setComponent<3>(v);        }

    //private:

        // Get J dot ((M-1)*J)  restrictions: |linear| = 1.0f
        HK_INLINE hkSimdReal getDiag(
            const hkpVelocityAccumulator& mA, const hkpVelocityAccumulator& mB ) const;

        // Get the non diagonal element of the 2*2 inverse mass matrix in the case that jacA and jacB share exactly the same rigid bodies.
        // Gets J dot ((M-1)*JacB).
        // This is a special implementation which makes use of the fact that some PlayStation(R)2 implementations left the last
        // Jacobian in registers. Be extra careful when using this function.
        HK_INLINE hkSimdReal getNonDiag(
            const hkpVelocityAccumulator& mA, const hkpVelocityAccumulator& mB, const hkp1Lin2AngJacobian& jacB ) const;

        // Get the non diagonal element in the case that jacA and jacB share exactly the same rigid bodies.
        // Gets J dot ((M-1)*JacB).
        // If this and jacB are connecting the same object pair in the same direction.
        HK_INLINE hkSimdReal getNonDiagSameObjects(
            const hkpVelocityAccumulator& mA, const hkpVelocityAccumulator& mB, const hkp1Lin2AngJacobian& jacB ) const;

        // Get the non diagonal element in the case of different rigid bodies.
        // Gets J dot ((M-1)*JacB).
        // Given that mA is the common object of both Jacobians and the mB differ.
        HK_INLINE hkSimdReal getNonDiagDifferentObjects(
            const hkpVelocityAccumulator& mA, const hkp1Lin2AngJacobian& jacB ) const;

        // Get J dot ((M-1)*JacB).
        // Given that mB of this Jacobian is mA of jacB.
        HK_INLINE hkSimdReal getNonDiagDifferentObjects_With2ndBodyFromFirstObject(
            const hkpVelocityAccumulator& mA, const hkp1Lin2AngJacobian& jacB ) const;

        // Compute J dot ((M-1)*J)  restrictions: |linear| = 1.0f
        template<class VEL>
        static HK_INLINE hkSimdReal computeDiag(
            hkVector4Parameter jacLinA, hkVector4Parameter jacAngA, hkVector4Parameter jacAngB,
            const VEL& velAccA, const VEL& velAccB );

    public:

        // The linear part or the constraint.
        //  .w component is the Rhs
        hkVector4 m_linear0;

        // The angular part of the constraint.
        //  angular[0].w component is the invJacDiag
        //  angular[1].w usage is dependent on the hkpJacobianSchema
        hkVector4 m_angular[2];
};


///
class hkpJacDouble2Bil
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpJacDouble2Bil );

        hkp1Lin2AngJacobian m_jac0;
        hkp1Lin2AngJacobian m_jac1;
};


///
class hkpJacTriple2Bil1Ang
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpJacTriple2Bil1Ang );

        hkp1Lin2AngJacobian m_jac0;
        hkp1Lin2AngJacobian m_jac1;
        hkp2AngJacobian     m_jac2;
};


///
class hkp2Lin2AngJacobian
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp2Lin2AngJacobian );

        // warning: call the next function only after setting the linear and angular part
        HK_INLINE void setRHS( hkReal v )                   {   m_linear[0](3) = v;                     }
        HK_INLINE void setRHS( hkSimdRealParameter v )      {   m_linear[0].setComponent<3>(v);         }
        HK_INLINE hkReal getRHS() const                     {   return m_linear[0](3);                  }
        HK_INLINE hkSimdReal getRhsSr() const               {   return m_linear[0].getComponent<3>();   }

        HK_INLINE hkReal getEffMass() const                 {   return m_angular[0](3);                 }
        HK_INLINE hkSimdReal getEffMassSr() const           {   return m_angular[0].getComponent<3>();  }
        HK_INLINE void setEffMass( hkReal v )               {   m_angular[0](3) = v;                    }
        HK_INLINE void setEffMass( hkSimdRealParameter v )  {   m_angular[0].setComponent<3>(v);        }

    //private:

        // Get J dot ((M-1)*J)  restrictions: |linear| = 1.0f
        HK_INLINE hkSimdReal getDiag(
            const hkpVelocityAccumulator& mA, const hkpVelocityAccumulator& mB, hkSimdRealParameter leverageRatio ) const;

    public:

        // The linear part of the constraint.
        //  m_linear[0].w component is the Rhs
        hkVector4 m_linear[2];

        // The angular part of the constraint.
        //  angular[0].w component is the invJacDiag
        //  angular[1].w usage is dependent on the hkpJacobianSchema
        hkVector4 m_angular[2];
};


#include <Physics/ConstraintSolver/Jacobian/hkpJacobianElement.inl>

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
