// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpJacobianSchema;
struct hkpConstraintRuntime;


/// A class containing a few pointers to buffers, where we expect
/// the results of an hkpConstraintData::buildJacobian() call
class HK_EXPORT_PHYSICS hkpConstraintQueryOut
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpConstraintQueryOut );

        /// Pointer to the schemas buffer.
        /// The ConstraintData::buildJacobian() implementation has to increment this pointer.
        hkpJacobianSchema* m_jacobianSchemas;

        /// Pointer to the constraint runtime for each atom. This is incremented for each atom (and therefore should be renamed to m_atomRuntime)
        hkpConstraintRuntime* m_constraintRuntime;

        /// Pointer to the constraint runtime which is owned by the constraint instance
        hkpConstraintRuntime* m_instanceRuntime;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
