// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/ConstraintSolver/Solve/hkpSolverResults.h>
#include <Common/Base/KeyCode.h>

#if defined HK_FEATURE_PRODUCT_PHYSICS_2012
#   include <Physics2012/Collide/hkpExport.h> 
#else
#   include <Physics/Physics/hknpExport.h> 
#endif

class hkpConstraintQueryIn;
class hkpConstraintQueryOut;
class hkpConstraintMotor;
class hkp2AngJacobian;
class hkp1Lin2AngJacobian;


/// A structure which is used for building Jacobian elements
class hkp1dBilateralConstraintStatus
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp1dBilateralConstraintStatus );

        /// The relative mass of the two objects in constraint space
        hkReal m_effMass;
};


/// The low level input structure to set up linear and angular motors for the constraint solver
class hkp1dConstraintMotorInfo
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp1dConstraintMotorInfo );

        /// The target position for the current frame
        hkReal  m_targetPosition;   

        /// The target velocity
        hkReal  m_targetVelocity;

        /// max force that can be applied
        hkReal  m_maxForce;

        /// max force that can be applied in the reverse direction
        hkReal  m_minForce;

        /// The relative stiffness of the motor between 0..1
        hkReal  m_tau;

        /// The relative damping of the motor between 0..1
        hkReal  m_damping;
};


/// The inputs for the hkpConstraintMotor::hkCalcMotorData method
class hkpConstraintMotorInput: public hkp1dBilateralConstraintStatus
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpConstraintMotorInput );

        /// delta time information about the solver (
        const class hkpConstraintQueryStepInfo* m_stepInfo;

        /// information from the last step
        hkpSolverResults m_lastResults;

        /// new target minus old target
        hkReal m_deltaTarget;

        /// old target minus current position
        hkReal m_positionError;
};


/// The outputs for the hkpConstraintMotor::hkCalcMotorData method
class hkpConstraintMotorOutput: public hkp1dConstraintMotorInfo
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpConstraintMotorOutput );
};


extern "C"
{
    /// Calculate the desired position and the forces we can apply to get there according to the implemented force law.
    HK_EXPORT_PHYSICS void HK_CALL hkCalcMotorData(_In_ const hkpConstraintMotor* someMotor, _In_ const hkpConstraintMotorInput* input, _Inout_ hkpConstraintMotorOutput* output);

    // Build Jacobian element
    HK_EXPORT_PHYSICS_2012 void HK_CALL hk1dAngularVelocityMotorBeginJacobian(hkVector4Parameter directionOfConstraint, const hkpConstraintQueryIn &in, _Inout_ hkp2AngJacobian* HK_RESTRICT jac, hkp1dBilateralConstraintStatus& statusOut);

    // Must call hk1dAngularVelocityMotorBeginJacobian first to build Jacobian in hkpConstraintQueryOut
    HK_EXPORT_PHYSICS_2012 void HK_CALL hk1dAngularVelocityMotorCommitJacobian(const hkp1dConstraintMotorInfo& info, const hkpConstraintQueryIn &in, _Inout_ hkp2AngJacobian* HK_RESTRICT jac, hkpConstraintQueryOut &out);

    // Build Jacobian element
    HK_EXPORT_PHYSICS void HK_CALL hk1dLinearVelocityMotorBeginJacobian(hkVector4Parameter directionOfConstraint, hkVector4Parameter pivot, const hkpConstraintQueryIn &in, _Inout_ hkp1Lin2AngJacobian* HK_RESTRICT jac, hkp1dBilateralConstraintStatus& statusOut);

    // Must call hk1dLinearVelocityMotorBeginJacobian first to build Jacobian in hkpConstraintQueryOut
    HK_EXPORT_PHYSICS void HK_CALL hk1dLinearVelocityMotorCommitJacobian(const hkp1dConstraintMotorInfo& info, const hkpConstraintQueryIn &in, _Inout_ hkp1Lin2AngJacobian* HK_RESTRICT jac, hkpConstraintQueryOut &out);
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
