// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/ConstraintSolver/Solve/hkpSolverInfo.h>
#include <Physics/ConstraintSolver/Constraint/Chain/hkpChainConstraintInfo.h>
#include <Common/Base/Math/Matrix/hkMatrix6.h>

class hkp1Lin2AngJacobian;
class hkp2AngJacobian;
class hkpVelocityAccumulator;
struct hkSolverStepTemp;


struct hkpConstraintChainMatrix6Triple
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpConstraintChainMatrix6Triple );

    hkMatrix6 m_lower;
    hkMatrix6 m_diagonalInv;
    hkMatrix6 m_upper;

    // Diagonal block of the original constraint matrix.
    hkMatrix6 m_mtxDiag;
    // Upper diagonal block of the original constraint matrix. (This block is located to the right of m_mtxDiag, and it is zero for the last row of the matrix.)
    hkMatrix6 m_mtxNextOffdiag;
};


struct HK_EXPORT_PHYSICS hkpChainSolverInfo
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpChainSolverInfo );

    hkpChainSolverInfo( const hkpSolverInfo& solverInfo ) : m_solverInfo(solverInfo) {}

    const hkpSolverInfo& m_solverInfo;

    int m_numConstraints;
    hkSimdReal m_schemaTau;
    hkSimdReal m_schemaDamping;

    hkp1Lin2AngJacobian* m_j;
    hkp2AngJacobian* m_jAng;
    hkpVelocityAccumulatorOffset* m_va;
    hkpVelocityAccumulator* m_accumsBase;
    hkpConstraintChainMatrix6Triple* m_triples;
    hkp3dAngularMotorSolverInfo* m_motorsState;


    hkVector8* m_gTempBuffer;
    hkVector8* m_velocitiesBuffer;
};


/// This structure holds a list of cfm parameters for a hkPoweredChain link
struct HK_EXPORT_PHYSICS hkpCfmParam
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpCfmParam );

        // Additive cfm parameter for the linear velocity equations
    hkReal m_linAdd;

        // Multiplicative cfm parameter for the linear velocity equations
    hkReal m_linMul;

        // Additive cfm parameter for the angular velocity equations
    hkReal m_angAdd;

        // Multiplicative cfm parameter for the angular velocity equations
    hkReal m_angMul;
};


// This structure holds a list of parameters required to build chain's jacobians.
struct HK_EXPORT_PHYSICS hkpPoweredChainBuildJacobianParams
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpPoweredChainBuildJacobianParams );

    int m_numConstraints;
    hkReal m_chainTau;
    hkReal m_chainDamping;
    hkpCfmParam m_cfm;
    hkpVelocityAccumulatorOffset* m_accumulators;
    const hkpVelocityAccumulator* m_accumsBase;
    hkp3dAngularMotorSolverInfo* m_motorsState;
    hkReal m_maxTorqueHysterisys;
    hkp3dAngularMotorSolverInfo::Status* m_childConstraintStatusWriteBackBuffer;
    hkp2AngJacobian* m_jacobiansEnd;
};


extern "C"
{
    HK_EXPORT_PHYSICS void HK_CALL hkPoweredChainBuildJacobian( const hkpPoweredChainBuildJacobianParams& params, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out );

    //
    //  Building constraint matrix and computing LU decomposition.
    //
    //  also updating LU decomposition from pre-calculated constraint matrix.
    //
    HK_EXPORT_PHYSICS void HK_CALL hkPoweredChain_BuildConstraintMatrixAndLuDecomposition(int numConstraints, const hkpCfmParam& cfm, _In_reads_(numConstraints) const hkp3dAngularMotorSolverInfo* motorsState, _Inout_updates_(numConstraints * 3 + 6) hkp1Lin2AngJacobian* HK_RESTRICT j, _In_reads_(numConstraints * 3 + 6) hkp2AngJacobian* HK_RESTRICT jAng, _In_reads_(numConstraints + 1) hkpVelocityAccumulatorOffset* HK_RESTRICT va, _In_ const hkpVelocityAccumulator* accumsBase, _In_reads_(numConstraints) hkpConstraintChainMatrix6Triple* triples, int bufferSize);

    HK_EXPORT_PHYSICS void HK_CALL hkPoweredChain_UpdateLuDecomposition(int firstConsraintToProcess, int numConstraints, _In_reads_(numConstraints) const hkp3dAngularMotorSolverInfo* motorsState, _Inout_updates_(numConstraints) hkpConstraintChainMatrix6Triple* triples);

    /*HK_INLINE*/
    void hkPoweredChain_ComputeConstraintMatrixLuDecomposition_ForOneRow(hkBool isNotLastRow, hkpConstraintChainMatrix6Triple& triple, _In_ const hkp3dAngularMotorSolverInfo* motorsState, hkMatrix6& mtxPrevOffdiag, _Inout_ hkMatrix6*& triplePrevUpper);

    //
    //  Computing constraint matrix blocks
    //
    HK_INLINE void hkPoweredChain_ComputeConstraintMatrix_DiagonalAtRow(int row, const hkpCfmParam& cfm, hkp1Lin2AngJacobian* HK_RESTRICT j, const hkp2AngJacobian* HK_RESTRICT jAng, _In_reads_(row + 2) const hkpVelocityAccumulatorOffset* HK_RESTRICT va, _In_ const hkpVelocityAccumulator* accumsBase, hkMatrix6& mtxDiag);

    HK_INLINE void hkPoweredChain_ComputeConstraintMatrix_NextOffDiagonalAtRow(int row, _In_reads_((row * 3) + 6) hkp1Lin2AngJacobian* j, _In_reads_((row * 3) + 6) hkp2AngJacobian* jAng, _In_reads_(row + 2) hkpVelocityAccumulatorOffset* va, _In_ const hkpVelocityAccumulator* accumsBase, hkMatrix6& mtxNextOffdiag);

    //
    //  Disabling of angular parts of constraints in the constraint matrix blocks
    //
    void HK_CALL hkPoweredChain_DisableMotorInMatrixRow_ThisConstraint(const hkp3dAngularMotorSolverInfo& motorsState, hkBool isNotLastRow, hkMatrix6& mtxDiag, hkMatrix6& mtxNextOffdiag);

    void HK_CALL hkPoweredChain_DisableMotorInMatrixRow_NextConstraint(const hkp3dAngularMotorSolverInfo& motorsState, hkMatrix6& mtxNextOffdiag);

    //
    // Constraint solving
    //
    HK_EXPORT_PHYSICS void HK_CALL hkPoweredChain_CalculateVelocities(const hkSolverStepTemp& temp, const hkpChainSolverInfo& info, _Inout_updates_(info.m_numConstraints) hkVector8* velocities);

    HK_EXPORT_PHYSICS void HK_CALL hkPoweredChain_OverwriteVelocityWithExplicitImpulse(int modifiedConstraintIndex, int modifiedCoordinateIndex, _In_reads_(modifiedConstraintIndex + 1) const hkp3dAngularMotorSolverInfo* motorsState, _Inout_updates_(modifiedConstraintIndex + 1) hkVector8* velocities);

    HK_EXPORT_PHYSICS void HK_CALL hkPoweredChain_RestoreVelocityValue(int modifiedConstraintIndex, int modifiedCoordinateIndex, const hkpChainSolverInfo& info, _Inout_updates_(modifiedConstraintIndex + 1) hkVector8* velocities);

    HK_EXPORT_PHYSICS void HK_CALL hkPoweredChain_SolveConstraintMatrix_ComputeVectorG(const hkpChainSolverInfo& info, _In_reads_(2) hkVector8* tempBufferG);

    HK_EXPORT_PHYSICS void HK_CALL hkPoweredChain_ScanAndDisableMotors(const hkpChainSolverInfo& info, int& modifiedChildConstraintIndex, int& modifiedCoordianteIndex, hkReal& impulse, _Reserved_ const hkp3dAngularMotorSolverInfo* /*not used*/ motorsState );

    HK_EXPORT_PHYSICS void HK_CALL hkPoweredChain_ScanAndEnableMotors(const hkpChainSolverInfo& info, int& modifiedChildConstraintIndex, int& modifiedCoordianteIndex, hkReal& impulse, _Reserved_ const hkp3dAngularMotorSolverInfo* /*not used*/ motorsState);

    HK_ON_DEBUG(HK_EXPORT_PHYSICS void HK_CALL hkPoweredChain_VerifyVelocities(const hkpChainSolverInfo& info, _Inout_updates_(info.m_numConstraints) hkVector8* velocities));
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
