// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpBallSocketChainData;

/// Stores values of matrices of LU decomposition of a tri-diagonal constraint matrix.
struct HK_EXPORT_PHYSICS hkpConstraintChainTriple
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpConstraintChainTriple );

    hkReal m_lower;
    hkReal m_diagonal; 
    hkReal m_upper;

    //          [ 0.diagonal                          ]   [ 1       1.upper           ]
    // A = LU = [ 1.lower     1.diagonal              ] * [         1         1.upper ]
    //          [             2.lower      2.diagonal ]   [                   1       ]
    //
    // number in 0.diagonal is the triple index.
    // blanks are zero
};


/// Stores values of matrices of LU decomposition of a block-tri-diagonal constraint matrix.
struct HK_EXPORT_PHYSICS hkpConstraintChainMatrixTriple
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpConstraintChainMatrixTriple );

    hkMatrix3 m_lower;
    hkMatrix3 m_diagonalInv;
    hkMatrix3 m_upper;

    //          [ 0.diagonalInv^-1                              ]   [ 1       1.upper           ]
    // A = LU = [ 1.lower          1.diagonal^-1                ] * [         1         1.upper ]
    //          [                  2.lower        2.diagonal^-1 ]   [                   1       ]
    //
    // number in 0.diagonal is the triple index.
    // blanks are zero
};


class hkpVelocityAccumulator;


class HK_EXPORT_PHYSICS hkpVelocityAccumulatorOffset
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpVelocityAccumulatorOffset );

        hkpVelocityAccumulatorOffset() {}

        inline hkpVelocityAccumulatorOffset(_In_ const hkpVelocityAccumulator* accumulatorBase, _In_ const hkpVelocityAccumulator* theOneAccumulator)
        {
            m_offset = static_cast<hkUint32>( hkGetByteOffset(accumulatorBase, theOneAccumulator) );
        }

        inline hkpVelocityAccumulator& getAccumulator(_In_ hkpVelocityAccumulator* accumulatorsBase) const { return *hkAddByteOffset(accumulatorsBase, m_offset); }
        inline const hkpVelocityAccumulator& getAccumulator(_In_ const hkpVelocityAccumulator* accumulatorsBase) const { return *hkAddByteOffsetConst(accumulatorsBase, m_offset); }

        hkUint32 m_offset;
};


class hkpConstraintQueryIn;
class hkpConstraintQueryOut;
class hkp1Lin2AngJacobian;


extern "C"
{
    HK_EXPORT_PHYSICS void HK_CALL hkBallSocketChainBuildJacobian(int numConstraints, hkReal tau, hkReal damping, hkReal cfm, _In_reads_(numConstraints + 1) const hkpVelocityAccumulatorOffset* accumulators, _In_ const hkpVelocityAccumulator* accumBase, _In_ hkp1Lin2AngJacobian* jacobiansEnd, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out);

    HK_EXPORT_PHYSICS void HK_CALL hkStabilizedBallSocketChainBuildJacobian(int numConstraints, hkReal tau, hkReal damping, hkReal cfm, hkReal ipm, hkVector4Parameter link0PivotBVelocityIn, _In_reads_(numConstraints + 1) const hkpVelocityAccumulatorOffset* accumulators, _In_ const hkpVelocityAccumulator* accumBase, _Inout_ class hkpChainLinkData* linkDatasEnd, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out);

    HK_EXPORT_PHYSICS void HK_CALL hkStiffSpringChainBuildJacobian(int numConstraints, hkReal tau, hkReal damping, hkReal cfm, _In_reads_(numConstraints + 1) const hkpVelocityAccumulatorOffset* accumulators, _In_ const hkpVelocityAccumulator* accumBase, _In_ hkp1Lin2AngJacobian* jacobiansEnd, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out);

    HK_EXPORT_PHYSICS void HK_CALL hkBallSocketConstraintBuildJacobian_noSchema_noProj(hkVector4Parameter pivotAWs, hkVector4Parameter pivotBWs, const hkpConstraintQueryIn &in, _Inout_ hkp1Lin2AngJacobian* jac);

    HK_EXPORT_PHYSICS void HK_CALL hkBallSocketConstraintBuildJacobian_noSchema_Proj(hkVector4Parameter pivotAWs, hkVector4Parameter pivotBWs, const hkpConstraintQueryIn &in, _Inout_ hkp1Lin2AngJacobian* jac);

    HK_EXPORT_PHYSICS void HK_CALL hkStabilizedBallSocketConstraintBuildJacobian_noSchema(hkVector4Parameter posA, hkVector4Parameter posB, hkReal maxAllowedErrorDistance, const hkpConstraintQueryIn &in, _Inout_ hkp1Lin2AngJacobian* jac);
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
