// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// We export both Physics and Physics 2012 in this file!
#include <Common/Base/KeyCode.h>
#if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
#   include <Physics2012/Collide/hkpExport.h> 
#elif defined(HK_FEATURE_PRODUCT_PHYSICS)
#   include <Physics/Physics/hknpExport.h> 
#endif

class hkpSolverResults;

///
class HK_EXPORT_PHYSICS hkp1dLinearBilateralConstraintInfo
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp1dLinearBilateralConstraintInfo );

        HK_INLINE hkp1dLinearBilateralConstraintInfo() {}

        /// the pivot point A in world space
        hkVector4 m_pivotA;

        /// the pivot point B in world space
        hkVector4 m_pivotB;

        /// defines the normal of a plane that movement is restricted to lay on, in world space
        hkVector4 m_constrainedDofW;
};


///
class HK_EXPORT_PHYSICS hkp1dLinearBilateralUserTauConstraintInfo : public hkp1dLinearBilateralConstraintInfo
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp1dLinearBilateralUserTauConstraintInfo );

            /// The stiffness of the constraint
        hkReal m_tau;

            /// The damping of the constraint
        hkReal m_damping;
};


///
class HK_EXPORT_PHYSICS hkp1dAngularBilateralConstraintInfo
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp1dAngularBilateralConstraintInfo );

        /// m_zeroErrorAxisAinW X m_zeroErrorAxisBinW = m_constrainedDofW
        HK_INLINE hkp1dAngularBilateralConstraintInfo() {}

            /// an axis perpendicular to the constraint axis, in world space
        hkVector4 m_zeroErrorAxisAinW;

            /// defines the axis that rotational movement is not allowed along, in world space
        hkVector4 m_constrainedDofW;

            /// perpendicular to m_zeroErrorAxisAinW axis and the constraint axis, transformed from B's local space into world space
        hkVector4 m_perpZeroErrorAxisBinW;
};


///
class HK_EXPORT_PHYSICS hkp1dLinearLimitInfo : public hkp1dLinearBilateralConstraintInfo
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp1dLinearLimitInfo );

        hkReal m_min;
        hkReal m_max;
};


///
class HK_EXPORT_PHYSICS hkp1dAngularFrictionInfo
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp1dAngularFrictionInfo );

        const hkVector4*      m_constrainedDofW;        // points to an array of axis
        hkpSolverResults*      m_lastSolverResults;
        hkReal                m_maxFrictionTorque;
        int                 m_numFriction;              // number of frictions added
};


///
class HK_EXPORT_PHYSICS hkp1dLinearFrictionInfo
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp1dLinearFrictionInfo );

        /// the pivot point in world space
        hkVector4 m_pivot;

        /// defines the normal of a plane that movement is restricted to lay on, in world space
        hkVector4 m_constrainedDofW;

        hkReal m_maxFrictionForce;

        hkpSolverResults* m_lastSolverResults;
};


///
class HK_EXPORT_PHYSICS hkp1dAngularLimitInfo
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkp1dAngularLimitInfo );

            /// defines the axis that rotational movement is not allowed along, in world space
        hkVector4 m_constrainedDofW;

            /// the lower limit of angular freedom
        hkReal m_min;

            /// the upper limit of angular freedom
        hkReal m_max;

            /// The current angle
        hkReal m_computedAngle;

            /// The tau used by the solver
        hkReal m_tau;

            /// The damping used by the solver
        hkReal m_damping;
};


/// Holds parameters needed to build Jacobians for a pulley constraint.
class HK_EXPORT_PHYSICS hkpPulleyConstraintInfo
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT_SOLVER, hkpPulleyConstraintInfo );

            /// Rope attachment point (pivot point) of body A in the global space.
        hkVector4 m_positionA;

            /// Rope attachment point (pivot point) of body B in the global space.
        hkVector4 m_positionB;

            /// Pulley pivot point on the bodyA's side; in the global space.
        hkVector4 m_pulleyPivotA;

            /// Pulley pivot point on the bodyB's side; in the global space
        hkVector4 m_pulleyPivotB;

            /// Combined length of rope used ( equal to (rope on bodyA's side + rope on bodyB's side * leverageOnBodyB) )
        hkReal m_ropeLength;

            /// Leverage on body B.
        hkReal m_leverageOnBodyB;
};


class hkpConstraintQueryIn;
class hkpConstraintQueryOut;
class hkpSolverResults;
class hkp1Lin2AngJacobian;


// Note some of these are Physics, some Physics 2012
extern "C"
{
    HK_EXPORT_PHYSICS void HK_CALL hk1dLinearBilateralConstraintBuildJacobian(const hkp1dLinearBilateralConstraintInfo& info, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out);

    HK_EXPORT_PHYSICS void HK_CALL hk1dLinearBilateralConstraintBuildJacobianWithCustomRhs(const hkp1dLinearBilateralConstraintInfo& info, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out, hkReal customRhs);

    HK_EXPORT_PHYSICS void HK_CALL hk1dLinearBilateralConstraintBuildJacobianWithCustomRhs_noSchema(const hkp1dLinearBilateralConstraintInfo& info, const hkpConstraintQueryIn &in, _Inout_ hkp1Lin2AngJacobian* HK_RESTRICT jac, hkReal customRhs);

    HK_EXPORT_PHYSICS void HK_CALL hk1dLinearBilateralConstraintUserTauBuildJacobian(const hkp1dLinearBilateralUserTauConstraintInfo& info, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out);

    HK_EXPORT_PHYSICS void HK_CALL hk1dAngularBilateralConstraintBuildJacobian(const hkp1dAngularBilateralConstraintInfo& info, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out);

    HK_EXPORT_PHYSICS void HK_CALL hk1dLinearLimitBuildJacobian(const hkp1dLinearLimitInfo& info, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out);

    HK_EXPORT_PHYSICS_2012 void HK_CALL hk1dAngularLimitBuildJacobian(const hkp1dAngularLimitInfo& info, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out);

    HK_EXPORT_PHYSICS_2012 void HK_CALL hk1dAngularFrictionBuildJacobian(const hkp1dAngularFrictionInfo& info, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out);

    HK_EXPORT_PHYSICS void HK_CALL hk1dLinearFrictionBuildJacobian(const hkp1dLinearFrictionInfo& info, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out);

    //
    // Modifiers
    //

    HK_EXPORT_PHYSICS void HK_CALL hkSetInvMassBuildJacobian(hkVector4Parameter invMassA, hkVector4Parameter invMassB, hkpConstraintQueryOut &out);

    HK_EXPORT_PHYSICS void HK_CALL hkAddVelocityBuildJacobian(hkVector4Parameter deltaVel, int bodyIndex, hkpConstraintQueryOut &out);

    HK_EXPORT_PHYSICS void HK_CALL hkSetCenterOfMassBuildJacobian(const hkMatrix3& angToLinVelA, const hkMatrix3& angToLinVelB, hkpConstraintQueryOut &out);
}

HK_INLINE void HK_CALL hkEndConstraints() {}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
